/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.infocenter;

import com.dlsc.gemsfx.infocenter.Notification;
import com.dlsc.gemsfx.infocenter.NotificationGroup;
import com.dlsc.gemsfx.skins.InfoCenterViewSkin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Duration;

public class InfoCenterView
extends Control {
    private static final String TRANSPARENT = "transparent";
    private final InvalidationListener updateNotificationsListener = it -> this.updateNotificationsList();
    private final WeakInvalidationListener weakUpdateNotificationsListener = new WeakInvalidationListener(this.updateNotificationsListener);
    private final InvalidationListener updatePinnedGroupsListener = it -> this.updatePinnedAndUnpinnedGroupsList();
    private final WeakInvalidationListener weakUpdatePinnedGroupsListener = new WeakInvalidationListener(this.updatePinnedGroupsListener);
    private final ObservableList<NotificationGroup<?, ?>> groups = FXCollections.observableArrayList();
    private final ObservableList<NotificationGroup<?, ?>> unpinnedGroups = FXCollections.observableArrayList();
    private final ObservableList<NotificationGroup<?, ?>> unmodifiableUnpinnedGroups = FXCollections.unmodifiableObservableList(this.unpinnedGroups);
    private final ObservableList<NotificationGroup<?, ?>> pinnedGroups = FXCollections.observableArrayList();
    private final ObservableList<NotificationGroup<?, ?>> unmodifiablePinnedGroups = FXCollections.unmodifiableObservableList(this.pinnedGroups);
    private final ObjectProperty<Consumer<NotificationGroup<?, ?>>> onShowAllGroupNotifications = new SimpleObjectProperty((Object)this, "onShowAllGroupNotifications");
    private final BooleanProperty autoOpenGroup = new SimpleBooleanProperty((Object)this, "autoOpenGroup", false);
    private final ObservableList<Notification<?>> notifications = FXCollections.observableArrayList();
    private final ObservableList<Notification<?>> unmodifiableNotifications = FXCollections.unmodifiableObservableList(this.notifications);
    private final ObservableList<Notification<?>> pinnedNotifications = FXCollections.observableArrayList();
    private final ObservableList<Notification<?>> unmodifiablePinnedNotifications = FXCollections.unmodifiableObservableList(this.pinnedNotifications);
    private final ObservableList<Notification<?>> unpinnedNotifications = FXCollections.observableArrayList();
    private final ObservableList<Notification<?>> unmodifiableUnpinnedNotifications = FXCollections.unmodifiableObservableList(this.unpinnedNotifications);
    private final ObjectProperty<NotificationGroup> showAllGroup = new SimpleObjectProperty((Object)this, "showAllGroup");
    private final ObjectProperty<Duration> showAllFadeDuration = new SimpleObjectProperty((Object)this, "showAllFadeDuration", (Object)Duration.millis((double)300.0));
    private final ObjectProperty<Duration> expandDuration = new SimpleObjectProperty((Object)this, "expandDuration", (Object)Duration.millis((double)300.0));
    private final ObjectProperty<Duration> slideInDuration = new SimpleObjectProperty((Object)this, "slideInDuration", (Object)Duration.millis((double)500.0));
    private final BooleanProperty transparent = new SimpleBooleanProperty((Object)this, "transparent", false);

    public InfoCenterView() {
        this.getStyleClass().add((Object)"info-center-view");
        ListChangeListener groupListListener = change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(group -> {
                        group.getNotifications().addListener((InvalidationListener)this.weakUpdateNotificationsListener);
                        group.pinnedProperty().addListener((InvalidationListener)this.weakUpdateNotificationsListener);
                        group.pinnedProperty().addListener((InvalidationListener)this.weakUpdatePinnedGroupsListener);
                    });
                    continue;
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(group -> {
                    group.getNotifications().removeListener((InvalidationListener)this.weakUpdateNotificationsListener);
                    group.pinnedProperty().removeListener((InvalidationListener)this.weakUpdateNotificationsListener);
                    group.pinnedProperty().removeListener((InvalidationListener)this.weakUpdatePinnedGroupsListener);
                });
            }
            this.updateNotificationsList();
            this.updatePinnedAndUnpinnedGroupsList();
        };
        this.getGroups().addListener(groupListListener);
        this.transparentProperty().addListener(it -> this.updateStyle());
    }

    protected Skin<?> createDefaultSkin() {
        return new InfoCenterViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return InfoCenterView.class.getResource("info-center-view.css").toExternalForm();
    }

    private void updateStyle() {
        this.getStyleClass().remove((Object)TRANSPARENT);
        if (this.isTransparent()) {
            this.getStyleClass().add((Object)TRANSPARENT);
        }
    }

    private void updateNotificationsList() {
        ArrayList allNotifications = new ArrayList();
        ArrayList allPinnedNotifications = new ArrayList();
        ArrayList allUnpinnedNotifications = new ArrayList();
        this.getGroups().forEach(group -> {
            allNotifications.addAll(group.getNotifications());
            if (group.isPinned()) {
                allPinnedNotifications.addAll(group.getNotifications());
            } else {
                allUnpinnedNotifications.addAll(group.getNotifications());
            }
        });
        this.notifications.setAll(allNotifications);
        this.pinnedNotifications.setAll(allPinnedNotifications);
        this.unpinnedNotifications.setAll(allUnpinnedNotifications);
    }

    private void updatePinnedAndUnpinnedGroupsList() {
        this.pinnedGroups.setAll((Collection)this.getGroups().stream().filter(group -> group.isPinned()).collect(Collectors.toList()));
        this.unpinnedGroups.setAll((Collection)this.getGroups().stream().filter(group -> !group.isPinned()).collect(Collectors.toList()));
    }

    public final ObservableList<NotificationGroup<?, ?>> getGroups() {
        return this.groups;
    }

    public final ObservableList<NotificationGroup<?, ?>> getUnmodifiableUnpinnedGroups() {
        return this.unmodifiableUnpinnedGroups;
    }

    public final ObservableList<NotificationGroup<?, ?>> getUnmodifiablePinnedGroups() {
        return this.unmodifiablePinnedGroups;
    }

    public final Consumer<NotificationGroup<?, ?>> getOnShowAllGroupNotifications() {
        return (Consumer)this.onShowAllGroupNotifications.get();
    }

    public final ObjectProperty<Consumer<NotificationGroup<?, ?>>> onShowAllGroupNotificationsProperty() {
        return this.onShowAllGroupNotifications;
    }

    public final void setOnShowAllGroupNotifications(Consumer<NotificationGroup<?, ?>> onShowAllGroupNotifications) {
        this.onShowAllGroupNotifications.set(onShowAllGroupNotifications);
    }

    public final boolean isAutoOpenGroup() {
        return this.autoOpenGroup.get();
    }

    public final BooleanProperty autoOpenGroupProperty() {
        return this.autoOpenGroup;
    }

    public final void setAutoOpenGroup(boolean autoOpenGroup) {
        this.autoOpenGroup.set(autoOpenGroup);
    }

    public final ObservableList<Notification<?>> getUnmodifiableNotifications() {
        return this.unmodifiableNotifications;
    }

    public final ObservableList<Notification<?>> getUnmodifiablePinnedNotifications() {
        return this.unmodifiablePinnedNotifications;
    }

    public final ObservableList<Notification<?>> getUnmodifiableUnpinnedNotifications() {
        return this.unmodifiableUnpinnedNotifications;
    }

    public final NotificationGroup getShowAllGroup() {
        return (NotificationGroup)this.showAllGroup.get();
    }

    public final ObjectProperty<NotificationGroup> showAllGroupProperty() {
        return this.showAllGroup;
    }

    public final void setShowAllGroup(NotificationGroup showAllGroup) {
        this.showAllGroup.set((Object)showAllGroup);
    }

    public final Duration getShowAllFadeDuration() {
        return (Duration)this.showAllFadeDuration.get();
    }

    public final ObjectProperty<Duration> showAllFadeDurationProperty() {
        return this.showAllFadeDuration;
    }

    public final void setShowAllFadeDuration(Duration showAllFadeDuration) {
        this.showAllFadeDuration.set((Object)showAllFadeDuration);
    }

    public final Duration getExpandDuration() {
        return (Duration)this.expandDuration.get();
    }

    public final ObjectProperty<Duration> expandDurationProperty() {
        return this.expandDuration;
    }

    public final void setExpandDuration(Duration expandDuration) {
        this.expandDuration.set((Object)expandDuration);
    }

    public final Duration getSlideInDuration() {
        return (Duration)this.slideInDuration.get();
    }

    public final ObjectProperty<Duration> slideInDurationProperty() {
        return this.slideInDuration;
    }

    public final void setSlideInDuration(Duration slideInDuration) {
        this.slideInDuration.set((Object)slideInDuration);
    }

    public final boolean isTransparent() {
        return this.transparent.get();
    }

    public final BooleanProperty transparentProperty() {
        return this.transparent;
    }

    public final void setTransparent(boolean transparent) {
        this.transparent.set(transparent);
    }

    public void clearAll() {
        this.getGroups().forEach(group -> group.getNotifications().clear());
    }
}

