/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.infocenter;

import com.dlsc.gemsfx.infocenter.Notification;
import com.dlsc.gemsfx.infocenter.NotificationView;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.util.Callback;

public class NotificationGroup<T, S extends Notification<T>>
implements Comparable<NotificationGroup> {
    private final StringProperty name = new SimpleStringProperty((Object)this, "name");
    private final IntegerProperty sortOrder = new SimpleIntegerProperty((Object)this, "sortOrder");
    private final ObservableList<S> notifications = FXCollections.observableArrayList();
    private final BooleanProperty expanded = new SimpleBooleanProperty((Object)this, "expanded", false);
    public final BooleanProperty showHeader = new SimpleBooleanProperty((Object)this, "showHeader", true);
    public final BooleanProperty pinnable = new SimpleBooleanProperty((Object)this, "pinnable", true);
    public final BooleanProperty pinned = new SimpleBooleanProperty((Object)this, "pinned");
    private final ObjectProperty<Callback<S, NotificationView<T, S>>> viewFactory = new SimpleObjectProperty((Object)this, "viewFactory");
    private final IntegerProperty maximumNumberOfNotifications = new SimpleIntegerProperty((Object)this, "maximumNumberOfNotifications", 10);
    private final BooleanProperty autoCollapse = new SimpleBooleanProperty((Object)this, "autoCollapse", true);

    public NotificationGroup(String name) {
        this.setName(Objects.requireNonNull(name));
        ListChangeListener listListener = change -> {
            while (change.next()) {
                if (!change.wasAdded()) continue;
                change.getAddedSubList().forEach(notification -> {
                    notification.setGroup(this);
                    notification.expandedProperty().bind((ObservableValue)this.expanded);
                });
            }
            if (this.isAutoCollapse() && this.notifications.size() < 2) {
                this.setExpanded(false);
            }
        };
        this.notifications.addListener(listListener);
        this.autoCollapseProperty().addListener(it -> {
            if (this.isAutoCollapse() && this.notifications.size() < 2) {
                this.setExpanded(false);
            }
        });
        this.setViewFactory(notification -> new NotificationView((Notification)notification));
    }

    public final String getName() {
        return (String)this.name.get();
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final void setName(String name) {
        this.name.set((Object)name);
    }

    public final Integer getSortOrder() {
        return this.sortOrder.get();
    }

    public final IntegerProperty sortOrderProperty() {
        return this.sortOrder;
    }

    public final void setSortOrder(Integer sortOrder) {
        this.sortOrder.set(sortOrder.intValue());
    }

    public final ObservableList<S> getNotifications() {
        return this.notifications;
    }

    public final boolean isExpanded() {
        return this.expanded.get();
    }

    public final BooleanProperty expandedProperty() {
        return this.expanded;
    }

    public final void setExpanded(boolean expanded) {
        this.expanded.set(expanded);
    }

    public final boolean isShowHeader() {
        return this.showHeader.get();
    }

    public final BooleanProperty showHeaderProperty() {
        return this.showHeader;
    }

    public final void setShowHeader(boolean showHeader) {
        this.showHeader.set(showHeader);
    }

    public final boolean isPinnable() {
        return this.pinnable.get();
    }

    public final BooleanProperty pinnableProperty() {
        return this.pinnable;
    }

    public final void setPinnable(boolean pinnable) {
        this.pinnable.set(pinnable);
    }

    public final boolean isPinned() {
        return this.pinned.get();
    }

    public final BooleanProperty pinnedProperty() {
        return this.pinned;
    }

    public final void setPinned(boolean pinned) {
        this.pinned.set(pinned);
    }

    public final Callback<S, NotificationView<T, S>> getViewFactory() {
        return (Callback)this.viewFactory.get();
    }

    public final ObjectProperty<Callback<S, NotificationView<T, S>>> viewFactoryProperty() {
        return this.viewFactory;
    }

    public final void setViewFactory(Callback<S, NotificationView<T, S>> viewFactory) {
        this.viewFactory.set(viewFactory);
    }

    public final int getMaximumNumberOfNotifications() {
        return this.maximumNumberOfNotifications.get();
    }

    public final IntegerProperty maximumNumberOfNotificationsProperty() {
        return this.maximumNumberOfNotifications;
    }

    public final void setMaximumNumberOfNotifications(int maximumNumberOfNotifications) {
        this.maximumNumberOfNotifications.set(maximumNumberOfNotifications);
    }

    public final boolean isAutoCollapse() {
        return this.autoCollapse.get();
    }

    public final BooleanProperty autoCollapseProperty() {
        return this.autoCollapse;
    }

    public final void setAutoCollapse(boolean autoCollapse) {
        this.autoCollapse.set(autoCollapse);
    }

    @Override
    public int compareTo(NotificationGroup o) {
        if (this.sortOrder.getValue() != null && o.getSortOrder() != null) {
            return this.sortOrder.getValue().compareTo(o.getSortOrder());
        }
        return this.getName().compareTo(o.getName());
    }
}

