/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.DurationPicker;
import com.dlsc.gemsfx.skins.DurationPickerPopup;
import com.dlsc.gemsfx.skins.DurationUnitField;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import javafx.util.Pair;
import org.kordamp.ikonli.javafx.FontIcon;

public class DurationPickerSkin
extends SkinBase<DurationPicker> {
    private final HBox innerBox = new HBox();
    private final DurationPickerPopup popup;
    private final List<DurationUnitField> durationUnitFields = new ArrayList<DurationUnitField>();

    public DurationPickerSkin(DurationPicker picker) {
        super((Control)picker);
        Button editButton = new Button();
        editButton.getStyleClass().add((Object)"edit-button");
        editButton.setOnAction(evt -> picker.getOnShowPopup().accept(picker));
        editButton.setMaxHeight(Double.MAX_VALUE);
        editButton.setGraphic((Node)new FontIcon());
        editButton.setFocusTraversable(false);
        editButton.visibleProperty().bind((ObservableValue)picker.showPopupTriggerButtonProperty());
        editButton.managedProperty().bind((ObservableValue)picker.showPopupTriggerButtonProperty());
        this.popup = new DurationPickerPopup();
        this.popup.durationProperty().bindBidirectional(picker.durationProperty());
        this.popup.minimumDurationProperty().bind(picker.minimumDurationProperty());
        this.popup.maximumDurationProperty().bind(picker.maximumDurationProperty());
        this.popup.fieldsProperty().bind(picker.fieldsProperty());
        picker.showingProperty().addListener(it -> {
            if (picker.isShowing()) {
                this.showPopup();
            } else {
                this.popup.hide();
            }
        });
        this.popup.setOnHidden(evt -> picker.getProperties().put((Object)"TIME_PICKER_POPUP", (Object)"TIME_PICKER_POPUP"));
        this.popup.addEventFilter(KeyEvent.KEY_PRESSED, evt -> {
            if (evt.getCode().equals((Object)KeyCode.ESCAPE)) {
                this.popup.hide();
            }
        });
        InvalidationListener updateListener = it -> this.buildView();
        picker.fieldsProperty().addListener(updateListener);
        this.innerBox.getStyleClass().add((Object)"fields-box");
        this.innerBox.setAlignment(Pos.CENTER_LEFT);
        Region spacer = new Region();
        spacer.getStyleClass().add((Object)"spacer");
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        HBox box = new HBox(new Node[]{this.innerBox, spacer, editButton});
        box.getStyleClass().add((Object)"box");
        this.getChildren().add((Object)box);
        picker.separatorFactoryProperty().addListener(it -> this.buildView());
        this.buildView();
    }

    private void showPopup() {
        DurationPicker picker = (DurationPicker)this.getSkinnable();
        Bounds bounds = picker.getBoundsInLocal();
        Bounds screenBounds = picker.localToScreen(bounds);
        int x = (int)screenBounds.getMinX();
        int y = (int)screenBounds.getMinY();
        int height = (int)screenBounds.getHeight();
        this.popup.show((Node)picker, x, y + height);
    }

    private void buildView() {
        int i;
        this.innerBox.getChildren().clear();
        this.durationUnitFields.clear();
        ObservableList<ChronoUnit> fields = ((DurationPicker)this.getSkinnable()).getFields();
        for (i = 0; i < fields.size(); ++i) {
            ChronoUnit chronoUnit = (ChronoUnit)fields.get(i);
            DurationUnitField unitField = this.createField(chronoUnit);
            this.durationUnitFields.add(unitField);
            this.innerBox.getChildren().add((Object)unitField);
            if (i >= fields.size() - 1) continue;
            Callback<Pair<ChronoUnit, ChronoUnit>, Node> separatorFactory = ((DurationPicker)this.getSkinnable()).getSeparatorFactory();
            Node separatorNode = (Node)separatorFactory.call((Object)new Pair((Object)chronoUnit, (Object)((ChronoUnit)fields.get(i + 1))));
            this.innerBox.getChildren().add((Object)separatorNode);
        }
        for (i = 0; i < this.durationUnitFields.size(); ++i) {
            DurationUnitField field = this.durationUnitFields.get(i);
            DurationUnitField previousField = null;
            DurationUnitField nextField = null;
            if (i > 0) {
                previousField = this.durationUnitFields.get(i - 1);
            }
            if (i < this.durationUnitFields.size() - 1) {
                nextField = this.durationUnitFields.get(i + 1);
            }
            if (previousField != null) {
                field.setPreviousField(previousField);
            }
            if (nextField == null) continue;
            field.setNextField(nextField);
        }
    }

    private DurationUnitField createField(ChronoUnit unit) {
        DurationUnitField field = new DurationUnitField((DurationPicker)this.getSkinnable(), unit);
        switch (unit) {
            default: {
                break;
            }
            case HOURS: {
                field.setMaximumValue(23L);
                break;
            }
            case MINUTES: 
            case SECONDS: {
                field.setMaximumValue(59L);
                break;
            }
            case MILLIS: {
                field.setMaximumValue(999L);
            }
        }
        field.setValue(0L);
        field.durationProperty().bind(((DurationPicker)this.getSkinnable()).durationProperty());
        field.labelTypeProperty().bind(((DurationPicker)this.getSkinnable()).labelTypeProperty());
        field.fillDigitsProperty().bind((ObservableValue)((DurationPicker)this.getSkinnable()).fillDigitsProperty());
        field.valueProperty().addListener(it -> {
            if (!field.isUpdating()) {
                ((DurationPicker)this.getSkinnable()).getProperties().put((Object)"NEW_DURATION", (Object)this.createDuration());
            }
        });
        return field;
    }

    private Duration createDuration() {
        Duration duration = Duration.ZERO;
        for (DurationUnitField field : this.durationUnitFields) {
            ChronoUnit chronoUnit = field.getChronoUnit();
            Long value = field.getValue();
            if (value == null) continue;
            duration = duration.plus((long)value, chronoUnit);
        }
        return duration;
    }
}

