/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.infocenter.InfoCenterEvent;
import com.dlsc.gemsfx.infocenter.InfoCenterView;
import com.dlsc.gemsfx.infocenter.Notification;
import com.dlsc.gemsfx.infocenter.NotificationGroup;
import com.dlsc.gemsfx.infocenter.NotificationView;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.animation.AnimationTimer;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.collections.transformation.SortedList;
import javafx.event.Event;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import one.jpro.jproutils.treeshowing.TreeShowing;
import org.kordamp.ikonli.javafx.FontIcon;

public class InfoCenterViewSkin
extends SkinBase<InfoCenterView> {
    private final VBox allGroupsContainer;
    private final VBox singleGroupContainer;
    private final ListView<Notification<?>> singleGroupListView = new ListView();
    private final InvalidationListener listItemsListener = it -> {
        InfoCenterView infoCenterView = (InfoCenterView)this.getSkinnable();
        if (infoCenterView.getShowAllGroup() != null && this.singleGroupListView.getItems().isEmpty()) {
            ((InfoCenterView)this.getSkinnable()).setShowAllGroup(null);
            if (infoCenterView.getUnmodifiableNotifications().isEmpty()) {
                this.singleGroupListView.fireEvent((Event)new InfoCenterEvent(InfoCenterEvent.HIDE));
            }
        }
    };
    private final WeakInvalidationListener weakListItemsListener = new WeakInvalidationListener(this.listItemsListener);
    private final VBox mainPane;
    private VBox unpinnedGroupsContainer = new VBox();
    private VBox pinnedGroupsContainer = new VBox();
    private final ObjectProperty<Notification<?>> animatedNotification = new SimpleObjectProperty((Object)this, "animatedNotification");

    public InfoCenterViewSkin(InfoCenterView view) {
        super((Control)view);
        if (view.getOnShowAllGroupNotifications() == null) {
            view.setOnShowAllGroupNotifications(group -> view.setShowAllGroup((NotificationGroup)group));
        }
        BooleanBinding pinnedNotificationsExist = Bindings.isNotEmpty(view.getUnmodifiablePinnedNotifications());
        BooleanBinding unpinnedNotificationsExist = Bindings.isNotEmpty(view.getUnmodifiableUnpinnedNotifications());
        this.pinnedGroupsContainer.getStyleClass().addAll((Object[])new String[]{"pinned", "container", "wrapper"});
        this.pinnedGroupsContainer.visibleProperty().bind((ObservableValue)pinnedNotificationsExist);
        this.pinnedGroupsContainer.managedProperty().bind((ObservableValue)pinnedNotificationsExist);
        this.pinnedGroupsContainer.setMinHeight(Double.NEGATIVE_INFINITY);
        Region separator = new Region();
        separator.getStyleClass().add((Object)"pinned-separator");
        separator.visibleProperty().bind((ObservableValue)pinnedNotificationsExist.and((ObservableBooleanValue)unpinnedNotificationsExist));
        separator.managedProperty().bind((ObservableValue)pinnedNotificationsExist.and((ObservableBooleanValue)unpinnedNotificationsExist));
        this.unpinnedGroupsContainer.getStyleClass().add((Object)"container");
        this.unpinnedGroupsContainer.setMinHeight(Double.NEGATIVE_INFINITY);
        ScrollPane scrollPane = new ScrollPane((Node)this.unpinnedGroupsContainer){

            protected double computePrefHeight(double width) {
                return InfoCenterViewSkin.this.unpinnedGroupsContainer.prefHeight(width - this.getInsets().getLeft() - this.getInsets().getRight()) + this.getInsets().getTop() + this.getInsets().getBottom();
            }

            public Orientation getContentBias() {
                return Orientation.HORIZONTAL;
            }
        };
        scrollPane.setPannable(true);
        scrollPane.setFitToHeight(false);
        scrollPane.setFitToWidth(true);
        scrollPane.visibleProperty().bind((ObservableValue)unpinnedNotificationsExist);
        scrollPane.managedProperty().bind((ObservableValue)unpinnedNotificationsExist);
        scrollPane.getStyleClass().add((Object)"wrapper");
        this.allGroupsContainer = new VBox(new Node[]{this.pinnedGroupsContainer, separator, scrollPane});
        this.allGroupsContainer.getStyleClass().add((Object)"all-groups-container");
        this.singleGroupListView.setCellFactory(lv -> new NotificationListCell());
        this.singleGroupListView.setSelectionModel(new MultipleSelectionModel<Notification<?>>(){

            public ObservableList<Integer> getSelectedIndices() {
                return FXCollections.observableArrayList();
            }

            public ObservableList<Notification<?>> getSelectedItems() {
                return FXCollections.observableArrayList();
            }

            public void selectIndices(int index, int ... indices) {
            }

            public void selectAll() {
            }

            public void selectFirst() {
            }

            public void selectLast() {
            }

            public void clearAndSelect(int index) {
            }

            public void select(int index) {
            }

            public void select(Notification<?> obj) {
            }

            public void clearSelection(int index) {
            }

            public void clearSelection() {
            }

            public boolean isSelected(int index) {
                return false;
            }

            public boolean isEmpty() {
                return true;
            }

            public void selectPrevious() {
            }

            public void selectNext() {
            }
        });
        this.singleGroupListView.itemsProperty().addListener((obs, oldItems, newItems) -> {
            if (oldItems != null) {
                oldItems.removeListener((InvalidationListener)this.weakListItemsListener);
            }
            if (newItems != null) {
                newItems.addListener((InvalidationListener)this.weakListItemsListener);
            }
        });
        VBox.setVgrow(this.singleGroupListView, (Priority)Priority.ALWAYS);
        if (view.getShowAllGroup() != null) {
            this.singleGroupListView.setItems(view.getShowAllGroup().getNotifications());
        }
        view.showAllGroupProperty().addListener(it -> {
            NotificationGroup showAllGroup = view.getShowAllGroup();
            if (showAllGroup != null) {
                this.singleGroupListView.setItems(view.getShowAllGroup().getNotifications());
            } else {
                this.singleGroupListView.setItems(FXCollections.observableArrayList());
            }
        });
        Label groupNameLabel = new Label();
        groupNameLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> view.getShowAllGroup() != null ? view.getShowAllGroup().getName() : "", (Observable[])new Observable[]{view.showAllGroupProperty()}));
        groupNameLabel.getStyleClass().add((Object)"group-name-label");
        groupNameLabel.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)groupNameLabel, (Priority)Priority.ALWAYS);
        Button closeShowAllButton = new Button("Close Group");
        closeShowAllButton.setTooltip(new Tooltip("Switch back to view with all groups"));
        closeShowAllButton.getStyleClass().add((Object)"close-show-all-button");
        closeShowAllButton.setOnAction(evt -> view.setShowAllGroup(null));
        Button clearAllButton = new Button();
        clearAllButton.setGraphic((Node)new FontIcon());
        clearAllButton.getStyleClass().add((Object)"clear-all-button");
        clearAllButton.setOnAction(evt -> view.getShowAllGroup().getNotifications().clear());
        clearAllButton.setTooltip(new Tooltip("Remove all notifications"));
        HBox singleGroupHeader = new HBox(new Node[]{groupNameLabel, closeShowAllButton, clearAllButton});
        singleGroupHeader.getStyleClass().add((Object)"single-group-header");
        this.singleGroupContainer = new VBox(new Node[]{singleGroupHeader, this.singleGroupListView});
        this.singleGroupContainer.getStyleClass().addAll((Object[])new String[]{"wrapper", "single-group-wrapper"});
        VBox.setVgrow((Node)this.singleGroupContainer, (Priority)Priority.ALWAYS);
        this.mainPane = new VBox(new Node[]{this.allGroupsContainer, this.singleGroupContainer});
        this.mainPane.setMinHeight(0.0);
        this.mainPane.setMaxHeight(Double.MAX_VALUE);
        this.mainPane.getStyleClass().add((Object)"main-pane");
        this.getChildren().add((Object)this.mainPane);
        InvalidationListener invalidationListener = it -> this.updateView();
        view.getUnmodifiablePinnedGroups().addListener(invalidationListener);
        view.getUnmodifiableUnpinnedGroups().addListener(invalidationListener);
        this.updateView();
        AnimationTimer timer = new AnimationTimer(){
            private long lastToggle;

            public void handle(long now) {
                if (this.lastToggle == 0L) {
                    InfoCenterViewSkin.this.updateTimes();
                    this.lastToggle = now;
                } else {
                    long diff = now - this.lastToggle;
                    if (diff >= 60000000000L) {
                        InfoCenterViewSkin.this.updateTimes();
                        this.lastToggle = now;
                    }
                }
            }
        };
        TreeShowing.treeShowing((Node)view).addListener((p, o, n) -> {
            if (n.booleanValue()) {
                timer.start();
            } else {
                timer.stop();
            }
        });
        timer.start();
        this.updateVisibilities();
        view.showAllGroupProperty().addListener(it -> this.updateVisibilities());
    }

    private void updateVisibilities() {
        if (((InfoCenterView)this.getSkinnable()).getShowAllGroup() != null) {
            this.singleGroupContainer.setVisible(true);
            this.singleGroupContainer.setManaged(true);
            this.allGroupsContainer.setVisible(false);
            this.allGroupsContainer.setManaged(false);
        } else {
            this.singleGroupContainer.setVisible(false);
            this.singleGroupContainer.setManaged(false);
            this.allGroupsContainer.setVisible(true);
            this.allGroupsContainer.setManaged(true);
        }
    }

    private void updateTimes() {
        this.unpinnedGroupsContainer.getChildren().stream().filter(node -> node instanceof GroupView).flatMap(groupView -> ((GroupView)((Object)groupView)).getChildren().stream()).filter(child -> child instanceof NotificationView).map(child -> (NotificationView)((Object)child)).collect(Collectors.toList()).forEach(notificationView -> notificationView.updateDateAndTimeLabel());
    }

    private void updateView() {
        this.pinnedGroupsContainer.getChildren().clear();
        this.unpinnedGroupsContainer.getChildren().clear();
        InfoCenterView view = (InfoCenterView)this.getSkinnable();
        List<NotificationGroup<?, ?>> sortedPinnedGroups = view.getUnmodifiablePinnedGroups().stream().sorted().collect(Collectors.toList());
        this.updateView(sortedPinnedGroups, this.pinnedGroupsContainer);
        List<NotificationGroup<?, ?>> sortedUnpinnedGroups = view.getUnmodifiableUnpinnedGroups().stream().sorted().collect(Collectors.toList());
        this.updateView(sortedUnpinnedGroups, this.unpinnedGroupsContainer);
    }

    private void updateView(List<NotificationGroup<?, ?>> groups, VBox container) {
        GroupView groupView;
        NotificationGroup<?, ?> group;
        int i;
        ArrayList<GroupView> groupViews = new ArrayList<GroupView>();
        int size = groups.size();
        for (i = 0; i < size; ++i) {
            group = groups.get(i);
            groupView = new GroupView(group);
            groupViews.add(groupView);
        }
        for (i = 0; i < size; ++i) {
            group = groups.get(i);
            groupView = (GroupView)((Object)groupViews.get(i));
            container.getChildren().add((Object)groupView);
            if (i >= size - 1) continue;
            Region spacer = new Region();
            spacer.getStyleClass().add((Object)"group-separator");
            container.getChildren().add((Object)spacer);
            GroupView nextGroupView = (GroupView)((Object)groupViews.get(i + 1));
            BooleanBinding showSpacerBinding = nextGroupView.visibleProperty().and((ObservableBooleanValue)group.expandedProperty()).and((ObservableBooleanValue)Bindings.size(group.getNotifications()).greaterThan(1));
            spacer.visibleProperty().bind((ObservableValue)showSpacerBinding);
            spacer.managedProperty().bind((ObservableValue)showSpacerBinding);
        }
    }

    private void configureNotificationView(NotificationView notificationView) {
        notificationView.setOnMouseClicked(evt -> {
            Object notification = notificationView.getNotification();
            NotificationGroup group = ((Notification)notification).getGroup();
            if (!evt.isConsumed() && evt.isStillSincePress() && evt.getClickCount() == 1 && evt.getButton().equals((Object)MouseButton.PRIMARY)) {
                if (group.isExpanded()) {
                    InfoCenterView infoCenterView = (InfoCenterView)this.getSkinnable();
                    infoCenterView.fireEvent(new InfoCenterEvent(InfoCenterEvent.NOTIFICATION_CHOSEN, (Notification<?>)notification));
                    Callback onClick = ((Notification)notification).getOnClick();
                    if (onClick != null) {
                        Notification.OnClickBehaviour behaviour = (Notification.OnClickBehaviour)((Object)((Object)onClick.call(notification)));
                        switch (behaviour) {
                            case NONE: {
                                break;
                            }
                            case REMOVE: {
                                ((Notification)notification).remove();
                                break;
                            }
                            case HIDE: {
                                notificationView.fireEvent(new InfoCenterEvent(InfoCenterEvent.HIDE));
                                infoCenterView.setShowAllGroup(null);
                                break;
                            }
                            case HIDE_AND_REMOVE: {
                                notificationView.fireEvent(new InfoCenterEvent(InfoCenterEvent.HIDE));
                                infoCenterView.setShowAllGroup(null);
                                ((Notification)notification).remove();
                            }
                        }
                    }
                } else {
                    group.setExpanded(true);
                }
                evt.consume();
            }
        });
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.mainPane.prefHeight(width - leftInset - rightInset) + topInset + bottomInset;
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.mainPane.minHeight(width - leftInset - rightInset) + topInset + bottomInset;
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.mainPane.maxHeight(width - leftInset - rightInset) + topInset + bottomInset;
    }

    private class NotificationListCell
    extends ListCell<Notification<?>> {
        public NotificationListCell() {
            this.getStyleClass().add((Object)"notification-list-cell");
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }

        protected void updateItem(Notification<?> notification, boolean empty) {
            super.updateItem(notification, empty);
            if (!empty && notification != null) {
                NotificationGroup group = notification.getGroup();
                Callback viewFactory = group.getViewFactory();
                NotificationView notificationView = (NotificationView)((Object)viewFactory.call(notification));
                notificationView.setPrefWidth(0.0);
                notificationView.getProperties().put((Object)"stacking-enabled", (Object)"false");
                InfoCenterViewSkin.this.configureNotificationView(notificationView);
                this.setGraphic((Node)notificationView);
            } else {
                this.setGraphic(null);
            }
        }
    }

    class GroupView<T, S extends Notification<T>>
    extends Pane {
        private final NotificationGroup<T, S> group;
        private final ListChangeListener<Notification> notificationsChangedListener = change -> {
            Notification theOne = null;
            while (change.next()) {
                if (change.wasAdded()) {
                    for (Notification notification2 : change.getAddedSubList()) {
                        if (theOne == null) {
                            theOne = notification2;
                        }
                        this.fireEvent(new InfoCenterEvent(InfoCenterEvent.NOTIFICATION_ADDED, notification2));
                    }
                    continue;
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(notification -> this.fireEvent(new InfoCenterEvent(InfoCenterEvent.NOTIFICATION_REMOVED, (Notification<?>)notification)));
            }
            this.updateStyleClass();
            this.createNotificationViews();
            if (theOne != null) {
                Notification finalOne = theOne;
                Platform.runLater(() -> {
                    if (((InfoCenterView)InfoCenterViewSkin.this.getSkinnable()).isAutoOpenGroup()) {
                        finalOne.getGroup().setExpanded(true);
                        Platform.runLater(() -> InfoCenterViewSkin.this.animatedNotification.set((Object)finalOne));
                    } else {
                        InfoCenterViewSkin.this.animatedNotification.set((Object)finalOne);
                    }
                });
            }
        };
        private final WeakListChangeListener<Notification> weakNotificationsChangedListener = new WeakListChangeListener(this.notificationsChangedListener);
        private final Timeline expandTimeline = new Timeline();
        private final HBox headerBox = new HBox();
        private final int SPACING = 10;
        private final InvalidationListener requestedNotificationListener = it -> this.showNotificationView();
        private final WeakInvalidationListener weakRequestedNotificationListener = new WeakInvalidationListener(this.requestedNotificationListener);
        private final DoubleProperty expansionProgress = new SimpleDoubleProperty((Object)this, "expansionProgress");

        public GroupView(NotificationGroup<T, S> group) {
            this.group = group;
            this.getStyleClass().add((Object)"group-view");
            this.headerBox.getStyleClass().add((Object)"header");
            Label groupNameLabel = new Label(group.getName());
            groupNameLabel.getStyleClass().add((Object)"group-name-label");
            groupNameLabel.setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)groupNameLabel, (Priority)Priority.ALWAYS);
            Button showLessButton = new Button("Show Less");
            showLessButton.getStyleClass().add((Object)"show-less-button");
            showLessButton.setOnAction(evt -> group.setExpanded(false));
            showLessButton.setTooltip(new Tooltip("Stack the notifications"));
            InfoCenterView infoCenterView = (InfoCenterView)InfoCenterViewSkin.this.getSkinnable();
            Button showAllButton = new Button();
            showAllButton.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> MessageFormat.format("Show All {0}", group.getNotifications().size()), (Observable[])new Observable[]{group.getNotifications()}));
            showAllButton.getStyleClass().add((Object)"show-all-button");
            showAllButton.setTooltip(new Tooltip("Show all notifications of this group in a list"));
            showAllButton.setOnAction(evt -> infoCenterView.getOnShowAllGroupNotifications().accept(group));
            showAllButton.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> infoCenterView.getOnShowAllGroupNotifications() != null && group.getNotifications().size() > group.getMaximumNumberOfNotifications(), (Observable[])new Observable[]{group.maximumNumberOfNotificationsProperty(), group.getNotifications(), infoCenterView.onShowAllGroupNotificationsProperty()}));
            Button clearButton = new Button();
            clearButton.getStyleClass().add((Object)"clear-button");
            clearButton.setTooltip(new Tooltip("Remove all notifications from the group"));
            clearButton.setGraphic((Node)new FontIcon());
            clearButton.setOnAction(evt -> {
                group.setExpanded(false);
                group.getNotifications().clear();
            });
            ToggleButton pinButton = new ToggleButton();
            pinButton.getStyleClass().add((Object)"pin-button");
            pinButton.setTooltip(new Tooltip("Pin the group at the top"));
            pinButton.setGraphic((Node)new FontIcon());
            pinButton.visibleProperty().bind((ObservableValue)group.pinnableProperty());
            pinButton.managedProperty().bind((ObservableValue)group.pinnableProperty());
            pinButton.selectedProperty().bindBidirectional((Property)group.pinnedProperty());
            this.headerBox.getChildren().addAll((Object[])new Node[]{groupNameLabel, showAllButton, showLessButton, clearButton, pinButton});
            this.headerBox.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> group.isExpanded() && group.getNotifications().size() > 1 && group.isShowHeader(), (Observable[])new Observable[]{group.expandedProperty(), group.getNotifications()}));
            group.getNotifications().addListener(this.weakNotificationsChangedListener);
            group.maximumNumberOfNotificationsProperty().addListener(it -> this.createNotificationViews());
            group.pinnedProperty().addListener(it -> this.updateStyleClass());
            group.expandedProperty().addListener(it -> {
                this.updateStyleClass();
                this.animate(group.isExpanded());
            });
            this.expansionProgressProperty().addListener(it -> this.layoutChildren());
            if (group.isExpanded()) {
                this.setExpansionProgress(1.0);
            } else {
                this.setExpansionProgress(0.0);
            }
            InfoCenterViewSkin.this.animatedNotification.addListener((InvalidationListener)this.weakRequestedNotificationListener);
            this.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty(group.getNotifications()));
            this.managedProperty().bind((ObservableValue)Bindings.isNotEmpty(group.getNotifications()));
            this.createNotificationViews();
            this.updateStyleClass();
        }

        private void updateStyleClass() {
            this.getStyleClass().removeAll((Object[])new String[]{"big-stack", "small-stack", "pinned", "expanded", "collapsed"});
            if (!this.group.isExpanded()) {
                this.getStyleClass().add((Object)"collapsed");
                if (this.group.getNotifications().size() > 2) {
                    this.getStyleClass().add((Object)"big-stack");
                } else if (this.group.getNotifications().size() > 1) {
                    this.getStyleClass().add((Object)"small-stack");
                }
            } else {
                this.getStyleClass().add((Object)"expanded");
            }
            if (this.group.isPinned()) {
                this.getStyleClass().add((Object)"pinned");
            }
        }

        private void showNotificationView() {
            Optional<NotificationView> notificationViewOptional;
            Notification notification = (Notification)InfoCenterViewSkin.this.animatedNotification.get();
            if (notification != null && notification.getGroup().equals(this.group) && (notificationViewOptional = this.getChildren().stream().filter(child -> child instanceof NotificationView).map(child -> (NotificationView)((Object)child)).filter(view -> view.getNotification().equals(notification)).findFirst()).isPresent()) {
                NotificationView notificationView = notificationViewOptional.get();
                notificationView.setTranslateX(this.getWidth());
                Timeline slideInTimeline = new Timeline();
                slideInTimeline.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(((InfoCenterView)InfoCenterViewSkin.this.getSkinnable()).getSlideInDuration(), new KeyValue[]{new KeyValue((WritableValue)notificationView.translateXProperty(), (Object)0, Interpolator.EASE_BOTH)})});
                slideInTimeline.play();
            }
        }

        public Orientation getContentBias() {
            return Orientation.HORIZONTAL;
        }

        protected double computePrefHeight(double width) {
            List notificationViews;
            double h = this.getInsets().getTop() + this.getInsets().getBottom();
            width = width - this.getInsets().getLeft() - this.getInsets().getRight();
            if (this.headerBox.isVisible()) {
                h += this.headerBox.prefHeight(width);
                h += 10.0;
            }
            if (!(notificationViews = this.getChildren().stream().filter(node -> node instanceof NotificationView).collect(Collectors.toList())).isEmpty()) {
                Node latestNotification = (Node)notificationViews.get(notificationViews.size() - 1);
                h += latestNotification.prefHeight(width);
            }
            double innerHeight = 0.0;
            if (notificationViews.size() > 1) {
                for (int i = notificationViews.size() - 2; i >= 0; --i) {
                    Node node2 = (Node)notificationViews.get(i);
                    innerHeight += 10.0;
                    innerHeight += node2.prefHeight(width);
                }
            }
            return h += innerHeight * this.getExpansionProgress();
        }

        protected void layoutChildren() {
            super.layoutChildren();
            double x = this.getInsets().getLeft();
            double y = this.getInsets().getTop();
            double w = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
            List notificationViews = this.getChildren().stream().filter(node -> node instanceof NotificationView).collect(Collectors.toList());
            int size = notificationViews.size();
            if (this.headerBox.isVisible()) {
                double boxHeight = this.headerBox.prefHeight(w);
                this.headerBox.resizeRelocate(x, y, w, boxHeight);
                y += boxHeight;
                y += 10.0;
            }
            for (int i = size - 1; i >= 0; --i) {
                Node node2 = (Node)notificationViews.get(i);
                double h = Math.max(node2.prefHeight(w), node2.minHeight(w));
                node2.resizeRelocate(x, y * this.getExpansionProgress(), w, h);
                y += h;
                if (i <= 0) continue;
                y += 10.0;
            }
        }

        private void animate(boolean expand) {
            KeyValue keyValue = new KeyValue((WritableValue)this.expansionProgress, (Object)(expand ? 1 : 0));
            KeyFrame keyFrame = new KeyFrame(((InfoCenterView)InfoCenterViewSkin.this.getSkinnable()).getExpandDuration(), new KeyValue[]{keyValue});
            this.expandTimeline.stop();
            this.expandTimeline.getKeyFrames().setAll((Object[])new KeyFrame[]{keyFrame});
            this.expandTimeline.play();
        }

        private void createNotificationViews() {
            int start;
            this.getChildren().setAll((Object[])new Node[]{this.headerBox});
            ObservableList<S> notifications = this.group.getNotifications();
            SortedList sorted = notifications.sorted();
            int count = sorted.size();
            for (int i = start = Math.max(0, count - this.group.getMaximumNumberOfNotifications()); i < count; ++i) {
                int index = i;
                Notification notification = (Notification)sorted.get(index);
                Callback<S, NotificationView<T, S>> viewFactory = this.group.getViewFactory();
                NotificationView notificationView = (NotificationView)((Object)viewFactory.call((Object)notification));
                notificationView.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> index == count - 1 || this.getExpansionProgress() > 0.0, (Observable[])new Observable[]{this.expansionProgress}));
                InfoCenterViewSkin.this.configureNotificationView(notificationView);
                if (i < count - 1) {
                    notificationView.opacityProperty().bind((ObservableValue)this.expansionProgressProperty());
                }
                this.getChildren().add((Object)notificationView);
            }
        }

        public double getExpansionProgress() {
            return this.expansionProgress.get();
        }

        public DoubleProperty expansionProgressProperty() {
            return this.expansionProgress;
        }

        public void setExpansionProgress(double expansionProgress) {
            this.expansionProgress.set(expansionProgress);
        }
    }
}

