/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.SearchField;
import com.dlsc.gemsfx.skins.SearchFieldPopupSkin;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.stage.PopupWindow;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;

public class SearchFieldPopup<T>
extends PopupControl {
    private final ObservableList<T> suggestions = FXCollections.observableArrayList();
    private final SearchField<T> searchField;
    public static final String DEFAULT_STYLE_CLASS = "search-field-popup";

    public SearchFieldPopup(SearchField<T> searchField) {
        this.searchField = Objects.requireNonNull(searchField);
        this.minWidthProperty().bind((ObservableValue)searchField.widthProperty());
        this.setAutoFix(true);
        this.setAutoHide(true);
        this.setHideOnEscape(true);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        searchField.addEventHandler(SearchField.SearchEvent.SEARCH_FINISHED, evt -> {
            if ((!searchField.getSuggestions().isEmpty() || searchField.getPlaceholder() != null) && StringUtils.isNotBlank((CharSequence)searchField.getEditor().getText())) {
                boolean showIt = false;
                if (searchField.getSuggestions().size() == 1) {
                    if (!(searchField.isHidePopupWithSingleChoice() && searchField.getMatcher().apply(searchField.getSuggestions().get(0), evt.getText()).booleanValue() || searchField.getConverter().toString(searchField.getSuggestions().get(0)).equalsIgnoreCase(searchField.getText()))) {
                        showIt = true;
                    }
                } else {
                    showIt = true;
                }
                if (showIt) {
                    this.show((Node)searchField);
                    this.selectFirstSuggestion();
                } else {
                    this.hide();
                }
            } else {
                this.hide();
            }
        });
    }

    public SearchField<T> getSearchField() {
        return this.searchField;
    }

    public ObservableList<T> getSuggestions() {
        return this.suggestions;
    }

    public void show(Node node) {
        Window parent;
        if (node.getScene() != null && node.getScene().getWindow() != null) {
            parent = node.getScene().getWindow();
            this.getScene().setNodeOrientation(node.getEffectiveNodeOrientation());
            if (node.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                this.setAnchorLocation(PopupWindow.AnchorLocation.CONTENT_TOP_RIGHT);
            } else {
                this.setAnchorLocation(PopupWindow.AnchorLocation.CONTENT_TOP_LEFT);
            }
        } else {
            throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
        }
        this.show(parent, parent.getX() + node.localToScene(0.0, 0.0).getX() + node.getScene().getX(), parent.getY() + node.localToScene(0.0, 0.0).getY() + node.getScene().getY() + node.getBoundsInParent().getHeight());
    }

    private void selectFirstSuggestion() {
        SearchFieldPopupSkin skin = (SearchFieldPopupSkin)this.getSkin();
        ListView listView = (ListView)skin.getNode();
        if (listView.getItems() != null && !listView.getItems().isEmpty()) {
            listView.getSelectionModel().select(0);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new SearchFieldPopupSkin(this);
    }
}

