/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.SearchField;
import com.dlsc.gemsfx.TagsField;
import com.dlsc.gemsfx.skins.SearchFieldEditorSkin;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.FlowPane;

public class TagsFieldSkin<T>
extends SkinBase<TagsField<T>> {
    private static final PseudoClass FILLED = PseudoClass.getPseudoClass((String)"filled");
    private static final PseudoClass CONTAINS_FOCUS = PseudoClass.getPseudoClass((String)"contains-focus");
    private static final PseudoClass SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private final FlowPane flowPane;
    private final Map<T, Node> tagViewMap = new HashMap<T, Node>();
    private int leadSelection;

    public TagsFieldSkin(TagsField<T> field) {
        super(field);
        this.flowPane = new FlowPane(){

            protected void layoutChildren() {
                super.layoutChildren();
                TextField editor = ((TagsField)TagsFieldSkin.this.getSkinnable()).getEditor();
                double w = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
                editor.resize(w - editor.getBoundsInParent().getMinX(), editor.getHeight());
            }
        };
        this.flowPane.getStyleClass().add((Object)"flow-pane");
        this.flowPane.prefWrapLengthProperty().bind((ObservableValue)field.widthProperty());
        field.getEditor().focusedProperty().addListener(it -> field.pseudoClassStateChanged(CONTAINS_FOCUS, field.getEditor().isFocused()));
        field.getTags().addListener(it -> this.pseudoClassStateChanged(FILLED, !field.getTags().isEmpty()));
        field.getEditor().setSkin(new SearchFieldEditorSkin<T>(field));
        this.getChildren().addAll((Object[])new Node[]{this.flowPane});
        field.setCellFactory(view -> new SearchField.SearchFieldListCell(field));
        field.getTagSelectionModel().getSelectedItems().addListener(it -> this.tagViewMap.entrySet().forEach(entry -> ((Node)entry.getValue()).pseudoClassStateChanged(SELECTED, field.getTagSelectionModel().getSelectedItems().contains(entry.getKey()))));
        field.getEditor().setOnMouseClicked(evt -> field.getTagSelectionModel().clearSelection());
        InvalidationListener updateViewListener = it -> this.updateView();
        field.tagViewFactoryProperty().addListener(updateViewListener);
        field.getTags().addListener(updateViewListener);
        this.updateView();
    }

    private void updateView() {
        this.flowPane.getChildren().clear();
        this.tagViewMap.clear();
        TagsField field = (TagsField)this.getSkinnable();
        TextField editor = field.getEditor();
        ObservableList tags = field.getTags();
        MultipleSelectionModel selectionModel = field.getTagSelectionModel();
        for (int i = 0; i < tags.size(); ++i) {
            Object tag = tags.get(i);
            int index = i;
            Node tagView = (Node)((TagsField)this.getSkinnable()).getTagViewFactory().call(tag);
            tagView.setFocusTraversable(false);
            tagView.getStyleClass().add((Object)"tag-view");
            tagView.setOnMousePressed(evt -> {
                field.getEditor().requestFocus();
                if (evt.getButton().equals((Object)MouseButton.PRIMARY)) {
                    if (evt.isShortcutDown()) {
                        if (!selectionModel.isSelected(index)) {
                            selectionModel.select(index);
                        } else {
                            selectionModel.clearSelection(index);
                        }
                    } else if (evt.isShiftDown()) {
                        if (this.leadSelection >= 0) {
                            int from = Math.min(this.leadSelection, index);
                            int to = Math.max(this.leadSelection, index);
                            selectionModel.selectRange(from, to + 1);
                        } else {
                            selectionModel.select(index);
                        }
                    } else {
                        boolean wasSelected = selectionModel.isSelected(index);
                        selectionModel.clearSelection();
                        if (!wasSelected) {
                            selectionModel.select(index);
                        }
                    }
                    this.leadSelection = index;
                }
            });
            if (tags.size() == 1) {
                tagView.getStyleClass().add((Object)"only");
            } else if (i == 0) {
                tagView.getStyleClass().add((Object)"first");
            } else if (i == tags.size() - 1) {
                tagView.getStyleClass().add((Object)"last");
            } else {
                tagView.getStyleClass().add((Object)"middle");
            }
            this.tagViewMap.put(tag, tagView);
            this.flowPane.getChildren().add((Object)tagView);
        }
        this.flowPane.getChildren().add((Object)editor);
    }
}

