/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.TimePicker;
import com.dlsc.gemsfx.skins.DigitsField;
import com.dlsc.gemsfx.skins.TimePickerPopup;
import java.time.LocalTime;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.kordamp.ikonli.javafx.FontIcon;

public class TimePickerSkin
extends SkinBase<TimePicker> {
    private static final PseudoClass EMPTY_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"empty");
    private final HourField hourField;
    private final MinuteField minuteField;
    private final Button editButton = new Button();
    private final TimePickerPopup popup;

    public TimePickerSkin(TimePicker picker) {
        super((Control)picker);
        this.hourField = new HourField(picker);
        this.minuteField = new MinuteField(picker);
        this.hourField.setNextField(this.minuteField);
        this.minuteField.setPreviousField(this.hourField);
        this.editButton.getStyleClass().add((Object)"edit-button");
        this.editButton.setOnAction(evt -> picker.getOnShowPopup().accept(picker));
        this.editButton.setMaxHeight(Double.MAX_VALUE);
        this.editButton.setGraphic((Node)new FontIcon());
        this.editButton.setFocusTraversable(false);
        this.editButton.visibleProperty().bind((ObservableValue)picker.showPopupTriggerButtonProperty());
        this.editButton.managedProperty().bind((ObservableValue)picker.showPopupTriggerButtonProperty());
        this.minuteField.stepRateProperty().bind((ObservableValue)picker.stepRateInMinutesProperty());
        InvalidationListener updateFocusListener = it -> this.updateFocus();
        this.hourField.focusedProperty().addListener(updateFocusListener);
        this.minuteField.focusedProperty().addListener(updateFocusListener);
        this.editButton.focusedProperty().addListener(updateFocusListener);
        this.popup = new TimePickerPopup();
        this.popup.timeProperty().bindBidirectional(picker.timeProperty());
        this.popup.stepRateInMinutesProperty().bind((ObservableValue)picker.stepRateInMinutesProperty());
        this.popup.clockTypeProperty().bind(picker.clockTypeProperty());
        this.popup.earliestTimeProperty().bind(picker.earliestTimeProperty());
        this.popup.latestTimeProperty().bind(picker.latestTimeProperty());
        picker.separatorProperty().addListener(it -> this.buildView());
        this.buildView();
        picker.timeProperty().addListener(it -> this.updateFieldValues());
        this.updateFieldValues();
        picker.showingProperty().addListener(it -> {
            if (picker.isShowing()) {
                this.showPopup();
            } else {
                this.popup.hide();
            }
        });
        this.popup.setOnHidden(evt -> picker.getProperties().put((Object)"TIME_PICKER_POPUP", (Object)"TIME_PICKER_POPUP"));
        this.popup.addEventFilter(KeyEvent.KEY_PRESSED, evt -> {
            if (evt.getCode().equals((Object)KeyCode.ESCAPE)) {
                this.popup.hide();
            }
        });
        this.updateEmptyPseudoClass();
    }

    private void updateEmptyPseudoClass() {
        this.hourField.pseudoClassStateChanged(EMPTY_PSEUDO_CLASS, ((TimePicker)this.getSkinnable()).getTime() == null);
        this.minuteField.pseudoClassStateChanged(EMPTY_PSEUDO_CLASS, ((TimePicker)this.getSkinnable()).getTime() == null);
        ((TimePicker)this.getSkinnable()).getSeparator().pseudoClassStateChanged(EMPTY_PSEUDO_CLASS, ((TimePicker)this.getSkinnable()).getTime() == null);
    }

    private void showPopup() {
        TimePicker picker = (TimePicker)this.getSkinnable();
        Bounds bounds = picker.getBoundsInLocal();
        Bounds screenBounds = picker.localToScreen(bounds);
        int x = (int)screenBounds.getMinX();
        int y = (int)screenBounds.getMinY();
        int height = (int)screenBounds.getHeight();
        this.popup.show((Node)picker, x, y + height);
    }

    private void updateFocus() {
        boolean wasFocused = ((TimePicker)this.getSkinnable()).getPseudoClassStates().stream().anyMatch(s -> s.getPseudoClassName().equals("focused"));
        if (!wasFocused) {
            ((TimePicker)this.getSkinnable()).getProperties().put((Object)"CLEAR_ADJUSTED_TIME", (Object)"CLEAR_ADJUSTED_TIME");
        }
        ((TimePicker)this.getSkinnable()).pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"focused"), this.minuteField.isFocused() || this.hourField.isFocused());
    }

    private void buildView() {
        Node separator = ((TimePicker)this.getSkinnable()).getSeparator();
        Region spacer = new Region();
        spacer.getStyleClass().add((Object)"spacer");
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        HBox fieldsBox = new HBox(new Node[]{this.hourField, separator, this.minuteField});
        fieldsBox.setFillHeight(true);
        fieldsBox.setAlignment(Pos.CENTER_LEFT);
        fieldsBox.getStyleClass().add((Object)"fields-box");
        HBox box = new HBox(new Node[]{fieldsBox, spacer, this.editButton});
        box.setFillHeight(true);
        box.getStyleClass().add((Object)"box");
        box.setAlignment(Pos.CENTER_LEFT);
        separator.setOnMouseClicked(evt -> this.minuteField.requestFocus());
        this.getChildren().add((Object)box);
    }

    private void updateFieldValues() {
        TimePicker picker = (TimePicker)this.getSkinnable();
        LocalTime time = picker.getTime();
        if (time != null) {
            this.hourField.setValue(time.getHour());
            this.minuteField.setValue(time.getMinute());
        } else {
            this.hourField.setValue(null);
            this.minuteField.setValue(null);
        }
        this.updateEmptyPseudoClass();
    }

    private class MinuteField
    extends DigitsField {
        public MinuteField(TimePicker picker) {
            super(picker, true);
            this.getStyleClass().add((Object)"minute");
            this.setMaximumValue(59);
            this.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
                if (evt.getCode().equals((Object)KeyCode.LEFT)) {
                    TimePickerSkin.this.hourField.requestFocus();
                    evt.consume();
                }
            });
            this.valueProperty().addListener(it -> {
                Integer value = this.getValue();
                if (value != null) {
                    value = Math.min(value, this.getMaximumValue());
                    LocalTime time = ((TimePicker)TimePickerSkin.this.getSkinnable()).getTime();
                    if (time != null) {
                        ((TimePicker)TimePickerSkin.this.getSkinnable()).getProperties().put((Object)"NEW_TIME", (Object)LocalTime.of(time.getHour(), value));
                    } else {
                        ((TimePicker)TimePickerSkin.this.getSkinnable()).getProperties().put((Object)"NEW_TIME", (Object)LocalTime.of(0, value));
                    }
                }
            });
        }
    }

    private class HourField
    extends DigitsField {
        public HourField(TimePicker picker) {
            super(picker, false);
            this.getStyleClass().add((Object)"hour");
            this.minimumValueProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((TimePicker)TimePickerSkin.this.getSkinnable()).getEarliestTime().getHour(), (Observable[])new Observable[]{((TimePicker)TimePickerSkin.this.getSkinnable()).earliestTimeProperty()}));
            this.maximumValueProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> ((TimePicker)TimePickerSkin.this.getSkinnable()).getLatestTime().getHour(), (Observable[])new Observable[]{((TimePicker)TimePickerSkin.this.getSkinnable()).latestTimeProperty()}));
            this.addEventHandler(KeyEvent.KEY_PRESSED, evt -> {
                if (evt.getCode().equals((Object)KeyCode.RIGHT)) {
                    TimePickerSkin.this.minuteField.requestFocus();
                    evt.consume();
                }
            });
            this.valueProperty().addListener(it -> {
                Integer value = this.getValue();
                if (value != null) {
                    value = Math.min(value, this.getMaximumValue());
                    LocalTime time = ((TimePicker)TimePickerSkin.this.getSkinnable()).getTime();
                    if (time != null) {
                        ((TimePicker)TimePickerSkin.this.getSkinnable()).getProperties().put((Object)"NEW_TIME", (Object)LocalTime.of(value, time.getMinute()));
                    } else {
                        ((TimePicker)TimePickerSkin.this.getSkinnable()).getProperties().put((Object)"NEW_TIME", (Object)LocalTime.of(value, 0));
                    }
                }
            });
        }
    }
}

