/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.util;

import java.util.Objects;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.StringProperty;

public class SessionManager {
    private static final Logger LOG = Logger.getLogger(SessionManager.class.getSimpleName());
    private final Preferences preferences;

    public SessionManager(Preferences preferences) {
        this.preferences = Objects.requireNonNull(preferences, "preferences can not be null");
    }

    public final Preferences getPreferences() {
        return this.preferences;
    }

    public void register(String path, DoubleProperty property) {
        LOG.fine("registering double property at path " + path);
        property.set(this.preferences.getDouble(path, property.get()));
        property.addListener((it, oldValue, newValue) -> {
            if (newValue != null) {
                this.preferences.putDouble(path, newValue.doubleValue());
            } else {
                this.preferences.remove(path);
            }
        });
    }

    public void register(String path, IntegerProperty property) {
        LOG.fine("registering integer property at path " + path);
        property.set(this.preferences.getInt(path, property.get()));
        property.addListener((it, oldValue, newValue) -> {
            if (newValue != null) {
                this.preferences.putInt(path, newValue.intValue());
            } else {
                this.preferences.remove(path);
            }
        });
    }

    public void register(String path, FloatProperty property) {
        LOG.fine("registering float property at path " + path);
        property.set(this.preferences.getFloat(path, property.get()));
        property.addListener((it, oldValue, newValue) -> {
            if (newValue != null) {
                this.preferences.putFloat(path, newValue.floatValue());
            } else {
                this.preferences.remove(path);
            }
        });
    }

    public void register(String path, LongProperty property) {
        LOG.fine("registering long property at path " + path);
        property.set(this.preferences.getLong(path, property.get()));
        property.addListener((it, oldValue, newValue) -> {
            if (newValue != null) {
                this.preferences.putLong(path, newValue.longValue());
            } else {
                this.preferences.remove(path);
            }
        });
    }

    public void register(String path, BooleanProperty property) {
        LOG.fine("registering boolean property at path " + path);
        property.set(this.preferences.getBoolean(path, property.get()));
        property.addListener((it, oldValue, newValue) -> {
            if (newValue != null) {
                this.preferences.putBoolean(path, (boolean)newValue);
            } else {
                this.preferences.remove(path);
            }
        });
    }

    public void register(String path, StringProperty property) {
        LOG.fine("registering string property at path " + path);
        property.set((Object)this.preferences.get(path, (String)property.get()));
        property.addListener((it, oldValue, newValue) -> {
            if (newValue != null) {
                this.preferences.put(path, (String)newValue);
            } else {
                this.preferences.remove(path);
            }
        });
    }
}

