/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.common.util;

import com.healthmarketscience.common.util.Appendee;
import java.io.IOException;
import java.util.Iterator;

public class AppendableExt
implements Appendable {
    private final Appendable _baseApp;
    private Appendable _app;
    private Object _context;

    public AppendableExt(Appendable app) {
        this(app, null);
    }

    public AppendableExt(Appendable app, Object context) {
        this._baseApp = app;
        this._app = app;
        this._context = context;
    }

    @Override
    public AppendableExt append(char c) throws IOException {
        this._app.append(c);
        return this;
    }

    @Override
    public AppendableExt append(CharSequence s) throws IOException {
        if (s instanceof Appendee) {
            return this.append((Appendee)((Object)s));
        }
        this._app.append(s);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppendableExt append(CharSequence s, int start, int end) throws IOException {
        if (start == end) {
            return this;
        }
        if (s instanceof Appendee) {
            Appendable oldApp = this._app;
            this._app = new SubRangeAppendable(oldApp, start, end);
            try {
                AppendableExt appendableExt = this.append((Appendee)((Object)s));
                return appendableExt;
            }
            finally {
                this._app = oldApp;
            }
        }
        this._app.append(s, start, end);
        return this;
    }

    public AppendableExt append(Appendee a) throws IOException {
        a.appendTo(this);
        return this;
    }

    public AppendableExt append(Object o) throws IOException {
        if (o instanceof Appendee) {
            return this.append((Appendee)o);
        }
        if (o instanceof CharSequence) {
            return this.append((CharSequence)o);
        }
        this._app.append(String.valueOf(o));
        return this;
    }

    public AppendableExt append(Iterable<?> iable, Object delimiter) throws IOException {
        Iterator<?> iter = iable.iterator();
        while (iter.hasNext()) {
            this.append(iter.next());
            if (!iter.hasNext()) continue;
            this.append(delimiter);
        }
        return this;
    }

    public Appendable getAppendable() {
        return this._baseApp;
    }

    public String toString() {
        return this._baseApp.toString();
    }

    public Object getContext() {
        return this._context;
    }

    public void setContext(Object newContext) {
        this._context = newContext;
    }

    private static class SubRangeAppendable
    implements Appendable {
        private final Appendable _delegate;
        private final int _start;
        private final int _end;
        private int _pos;

        private SubRangeAppendable(Appendable delegate, int start, int end) {
            this._delegate = delegate;
            this._start = start;
            this._end = end;
        }

        @Override
        public Appendable append(char c) throws IOException {
            if (this._pos >= this._start && this._pos < this._end) {
                this._delegate.append(c);
            }
            ++this._pos;
            return this;
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            int len = csq.length();
            if (this._pos >= this._start && this._end - this._pos >= len) {
                this._delegate.append(csq);
                this._pos += len;
            } else {
                this.append(csq, 0, len);
            }
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            if (start < 0 || end < 0 || start > end || end > csq.length()) {
                throw new IndexOutOfBoundsException("invalid start " + start + " or end " + end + ", length " + csq.length());
            }
            if (this._pos >= this._end) {
                return this;
            }
            if (this._pos < this._start) {
                int skip = Math.min(end - start, this._start - this._pos);
                start += skip;
                this._pos += skip;
            }
            if (start >= end) {
                return this;
            }
            int len = Math.min(end - start, this._end - this._pos);
            end = start + len;
            this._delegate.append(csq, start, end);
            this._pos += len;
            return this;
        }
    }
}

