/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;

public class BetweenCondition
extends Condition {
    private boolean _negate;
    private SqlObject _value;
    private SqlObject _minValue;
    private SqlObject _maxValue;

    public BetweenCondition(Object obj, Object minObj, Object maxObj) {
        this._value = Converter.toColumnSqlObject(obj);
        this._minValue = Converter.toColumnSqlObject(minObj);
        this._maxValue = Converter.toColumnSqlObject(maxObj);
    }

    public BetweenCondition setNegate(boolean negate) {
        this._negate = negate;
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        this._value.collectSchemaObjects(vContext);
        this._minValue.collectSchemaObjects(vContext);
        this._maxValue.collectSchemaObjects(vContext);
    }

    @Override
    public void appendTo(AppendableExt app) throws IOException {
        this.openParen(app);
        app.append(this._value).append(this._negate ? " NOT BETWEEN " : " BETWEEN ").append(this._minValue).append(" AND ").append(this._maxValue);
        this.closeParen(app);
    }
}

