/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Expression;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;

public class BooleanValueObject
extends Expression {
    public static final String USE_BOOLEAN_LITERALS_PROPERTY = "com.healthmarketscience.sqlbuilder.useBooleanLiterals";
    private static final boolean USE_LITERAL_VALUES = Boolean.getBoolean("com.healthmarketscience.sqlbuilder.useBooleanLiterals");
    private static final Object TRUE_VALUE = USE_LITERAL_VALUES ? "TRUE" : Integer.valueOf(1);
    private static final Object FALSE_VALUE = USE_LITERAL_VALUES ? "FALSE" : Integer.valueOf(0);
    public static final BooleanValueObject TRUE = new BooleanValueObject(true);
    public static final BooleanValueObject FALSE = new BooleanValueObject(false);
    private Boolean _value;

    public BooleanValueObject(Object value) {
        this((Boolean)value);
    }

    public BooleanValueObject(Boolean value) {
        this._value = value;
    }

    public static BooleanValueObject valueOf(Boolean value) {
        return value != false ? TRUE : FALSE;
    }

    public static BooleanValueObject valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    public boolean hasParens() {
        return false;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
    }

    @Override
    public void appendTo(AppendableExt app) throws IOException {
        app.append(BooleanValueObject.toSqlValue(this._value));
    }

    private static Object toSqlValue(Boolean b) {
        return b != false ? TRUE_VALUE : FALSE_VALUE;
    }
}

