/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.CheckConstraintClause;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.ForeignKeyConstraintClause;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.dbspec.CheckConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.ForeignKeyConstraint;
import java.io.IOException;
import java.util.List;

public class ConstraintClause
extends SqlObject {
    protected final Type _type;
    protected final SqlObject _name;
    protected SqlObjectList<SqlObject> _columns = SqlObjectList.create();
    protected Object _checkTime;

    public ConstraintClause(Constraint constraint) {
        this(ConstraintClause.getType(constraint.getType()), constraint, constraint.getColumns());
    }

    public ConstraintClause(Type type, Object name) {
        this(type, name, null);
    }

    protected ConstraintClause(Type type, Object name, List<?> columns) {
        this._type = type;
        this._name = Converter.toCustomConstraintSqlObject(name);
        this._columns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columns);
    }

    public ConstraintClause addColumns(Column ... columns) {
        return this.addCustomColumns(columns);
    }

    public ConstraintClause addCustomColumns(Object ... columnStrs) {
        this._columns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        return this;
    }

    public ConstraintClause setCheckTime(Object checkTime) {
        this._checkTime = checkTime;
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        if (this._name != null) {
            this._name.collectSchemaObjects(vContext);
        }
        this._columns.collectSchemaObjects(vContext);
    }

    @Override
    public void appendTo(AppendableExt app) throws IOException {
        this.preAppendTo(app);
        this.postAppendTo(app);
    }

    protected void preAppendTo(AppendableExt app) throws IOException {
        if (this._name != null) {
            app.append(this._name);
        }
        boolean forTable = SqlContext.getContext(app).getUseTableConstraints();
        app.append(this._type.toString(forTable));
        if (forTable && !this._columns.isEmpty()) {
            app.append(" (").append(this._columns).append(")");
        }
    }

    protected void postAppendTo(AppendableExt app) throws IOException {
        if (this._checkTime != null) {
            app.append(" ").append(this._checkTime);
        }
    }

    private static Type getType(Constraint.Type consType) {
        return Type.valueOf(consType.name());
    }

    public static ConstraintClause from(Constraint cons) {
        switch (cons.getType()) {
            case FOREIGN_KEY: {
                return new ForeignKeyConstraintClause((ForeignKeyConstraint)cons);
            }
            case CHECK: {
                return new CheckConstraintClause((CheckConstraint)cons);
            }
        }
        return new ConstraintClause(cons);
    }

    public static ConstraintClause notNull() {
        return ConstraintClause.notNull(null);
    }

    public static ConstraintClause notNull(Object name) {
        return new ConstraintClause(Type.NOT_NULL, name);
    }

    public static ConstraintClause unique() {
        return ConstraintClause.unique(null);
    }

    public static ConstraintClause unique(Object name) {
        return new ConstraintClause(Type.UNIQUE, name);
    }

    public static ConstraintClause primaryKey() {
        return ConstraintClause.primaryKey(null);
    }

    public static ConstraintClause primaryKey(Object name) {
        return new ConstraintClause(Type.PRIMARY_KEY, name);
    }

    public static ForeignKeyConstraintClause foreignKey(Object refTableStr) {
        return ConstraintClause.foreignKey(null, refTableStr);
    }

    public static ForeignKeyConstraintClause foreignKey(Object name, Object refTableStr) {
        return new ForeignKeyConstraintClause(name, refTableStr);
    }

    public static CheckConstraintClause checkCondition(Condition checkCondition) {
        return ConstraintClause.checkCondition(null, checkCondition);
    }

    public static CheckConstraintClause checkCondition(Object name, Condition checkCondition) {
        return new CheckConstraintClause(name, checkCondition);
    }

    static class Prefix
    extends SqlObject {
        private SqlObject _name;

        Prefix(SqlObject name) {
            this._name = name;
        }

        @Override
        protected void collectSchemaObjects(ValidationContext vContext) {
            this._name.collectSchemaObjects(vContext);
        }

        @Override
        public void appendTo(AppendableExt app) throws IOException {
            app.append("CONSTRAINT ").append(this._name).append(" ");
        }
    }

    public static enum CheckTime {
        NOT_DEFERRABLE("NOT DEFERRABLE"),
        DEFERRABLE_INITIALLY_DEFERRED("DEFERRABLE INITIALLY DEFERRED"),
        DEFERRABLE_INITIALLY_IMMEDIATE("DEFERRABLE INITIALLY IMMEDIATE");

        private final String _str;

        private CheckTime(String str) {
            this._str = str;
        }

        public String toString() {
            return this._str;
        }
    }

    public static enum Type {
        NOT_NULL("NOT NULL"),
        UNIQUE("UNIQUE"),
        PRIMARY_KEY("PRIMARY KEY"),
        FOREIGN_KEY("FOREIGN KEY", "REFERENCES"),
        CHECK("CHECK");

        private final String _tableTypeStr;
        private final String _colTypeStr;

        private Type(String colTypeStr) {
            this(colTypeStr, colTypeStr);
        }

        private Type(String tableTypeStr, String colTypeStr) {
            this._tableTypeStr = tableTypeStr;
            this._colTypeStr = colTypeStr;
        }

        public String toString(boolean forTable) {
            return forTable ? this._tableTypeStr : this._colTypeStr;
        }
    }
}

