/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.ExceptQuery;
import com.healthmarketscience.sqlbuilder.IntersectQuery;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.Query;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.Subquery;
import com.healthmarketscience.sqlbuilder.UnionQuery;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import java.io.IOException;

public class SetOperationQuery<ThisType extends SetOperationQuery<ThisType>>
extends Query<ThisType> {
    private Type _defaultType;
    private SqlObjectList<RelateTo> _queries = SqlObjectList.create("");
    private SqlObjectList<SqlObject> _ordering = SqlObjectList.create();

    public SetOperationQuery(Type type) {
        this(type, null);
    }

    public SetOperationQuery(Type type, Object ... queries) {
        this._defaultType = type;
        this.addQueriesImpl(this._defaultType, queries);
    }

    private void addQueriesImpl(final Type type, Object[] queries) {
        this._queries.addObjects(new Converter<Object, RelateTo>(){

            @Override
            public RelateTo convert(Object src) {
                return SetOperationQuery.this._queries.isEmpty() ? new RelateTo(null, src) : new RelateTo(type, src);
            }
        }, queries);
    }

    public ThisType addQueries(SelectQuery ... queries) {
        return this.addQueries((Object[])queries);
    }

    public ThisType addQueries(Type type, SelectQuery ... queries) {
        return this.addQueries(type, (Object[])queries);
    }

    public ThisType addQueries(Object ... queries) {
        return this.addQueries(this._defaultType, queries);
    }

    public ThisType addQueries(Type type, Object ... queries) {
        this.addQueriesImpl(type, queries);
        return (ThisType)((SetOperationQuery)this.getThisType());
    }

    public ThisType addCustomOrdering(Object columnStr, OrderObject.Dir dir) {
        return this.addCustomOrderings(new OrderObject(dir, Converter.toCustomColumnSqlObject(columnStr)));
    }

    public ThisType addCustomOrderings(Object ... columnStrs) {
        this._ordering.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        return (ThisType)((SetOperationQuery)this.getThisType());
    }

    public ThisType addOrdering(Column column, OrderObject.Dir dir) {
        return this.addCustomOrdering(column, dir);
    }

    public ThisType addOrderings(Column ... columns) {
        return this.addCustomOrderings(columns);
    }

    public ThisType addIndexedOrdering(Integer columnIdx, OrderObject.Dir dir) {
        return this.addCustomOrdering(columnIdx, dir);
    }

    public ThisType addIndexedOrderings(Integer ... columnIdxs) {
        return this.addCustomOrderings(columnIdxs);
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        super.validate(vContext);
        int currentCount = -1;
        boolean ignoreColumnCount = false;
        for (RelateTo relateTo : this._queries) {
            SqlObject queryObj = relateTo.getQuery();
            if (!(queryObj instanceof SelectQuery)) continue;
            SelectQuery selectQuery = (SelectQuery)queryObj;
            if (!ignoreColumnCount) {
                if (selectQuery.hasAllColumns()) {
                    ignoreColumnCount = true;
                } else if (currentCount < 0) {
                    currentCount = selectQuery.getColumns().size();
                } else if (currentCount != selectQuery.getColumns().size()) {
                    throw new ValidationException("mismatched number of columns in union statement, found " + currentCount + " while query has " + selectQuery.getColumns().size());
                }
            }
            if (selectQuery.getOrdering().isEmpty()) continue;
            throw new ValidationException("Union selects may not have ordering clause");
        }
        SelectQuery.validateOrdering(currentCount, this._ordering, ignoreColumnCount);
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._queries.collectSchemaObjects(vContext);
    }

    @Override
    protected void appendTo(AppendableExt app, SqlContext newContext) throws IOException {
        newContext.setUseTableAliases(false);
        app.append(this._queries);
        if (!this._ordering.isEmpty()) {
            app.append(" ORDER BY ").append(this._ordering);
        }
    }

    SqlObject getFirstQuery() {
        return !this._queries.isEmpty() ? this._queries.get(0).getQuery() : null;
    }

    public static UnionQuery union() {
        return new UnionQuery(Type.UNION);
    }

    public static UnionQuery union(SelectQuery ... queries) {
        return new UnionQuery(Type.UNION, queries);
    }

    public static UnionQuery unionAll() {
        return new UnionQuery(Type.UNION_ALL);
    }

    public static UnionQuery unionAll(SelectQuery ... queries) {
        return new UnionQuery(Type.UNION_ALL, queries);
    }

    public static ExceptQuery except() {
        return new ExceptQuery(Type.EXCEPT);
    }

    public static ExceptQuery except(SelectQuery ... queries) {
        return new ExceptQuery(Type.EXCEPT, queries);
    }

    public static ExceptQuery exceptAll() {
        return new ExceptQuery(Type.EXCEPT_ALL);
    }

    public static ExceptQuery exceptAll(SelectQuery ... queries) {
        return new ExceptQuery(Type.EXCEPT_ALL, queries);
    }

    public static IntersectQuery intersect() {
        return new IntersectQuery(Type.INTERSECT);
    }

    public static IntersectQuery intersect(SelectQuery ... queries) {
        return new IntersectQuery(Type.INTERSECT, queries);
    }

    public static IntersectQuery intersectAll() {
        return new IntersectQuery(Type.INTERSECT_ALL);
    }

    public static IntersectQuery intersectAll(SelectQuery ... queries) {
        return new IntersectQuery(Type.INTERSECT_ALL, queries);
    }

    private static class RelateTo
    extends Subquery {
        private Type _type;

        private RelateTo(Type type, Object query) {
            super(query);
            this._type = type;
        }

        private SqlObject getQuery() {
            return this._query;
        }

        @Override
        public void appendTo(AppendableExt app) throws IOException {
            if (this._type != null) {
                app.append((Object)this._type);
            }
            app.append(this.getQuery());
        }
    }

    public static enum Type {
        UNION(" UNION "),
        UNION_ALL(" UNION ALL "),
        EXCEPT(" EXCEPT "),
        EXCEPT_ALL(" EXCEPT ALL "),
        INTERSECT(" INTERSECT "),
        INTERSECT_ALL(" INTERSECT ALL ");

        private final String _typeStr;

        private Type(String typeStr) {
            this._typeStr = typeStr;
        }

        public String toString() {
            return this._typeStr;
        }
    }
}

