/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.Section;
import java.util.HashMap;
import java.util.Iterator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class SectionBuilder<B extends SectionBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected SectionBuilder() {
    }

    public static final SectionBuilder create() {
        return new SectionBuilder();
    }

    public final B start(double VALUE) {
        this.properties.put("start", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B stop(double VALUE) {
        this.properties.put("stop", (Property)new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B text(String TEXT) {
        this.properties.put("text", (Property)new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B icon(Image IMAGE) {
        this.properties.put("icon", (Property)new SimpleObjectProperty((Object)IMAGE));
        return (B)this;
    }

    public final B color(Color COLOR) {
        this.properties.put("color", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B highlightColor(Color COLOR) {
        this.properties.put("highlightColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", (Property)new SimpleObjectProperty((Object)COLOR));
        return (B)this;
    }

    public final B active(boolean ACTIVE) {
        this.properties.put("active", (Property)new SimpleBooleanProperty(ACTIVE));
        return (B)this;
    }

    public final B styleClass(String STYLE_CLASS) {
        this.properties.put("styleClass", (Property)new SimpleStringProperty(STYLE_CLASS));
        return (B)this;
    }

    public final B onSectionEntered(EventHandler<Section.SectionEvent> HANDLER) {
        this.properties.put("onSectionEntered", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final B onSectionLeft(EventHandler<Section.SectionEvent> HANDLER) {
        this.properties.put("onSectionLeft", (Property)new SimpleObjectProperty(HANDLER));
        return (B)this;
    }

    public final Section build() {
        Section SECTION = new Section();
        Iterator<String> iterator = this.properties.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "start": {
                    SECTION.setStart(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "stop": {
                    SECTION.setStop(((DoubleProperty)this.properties.get(key)).get());
                    break;
                }
                case "text": {
                    SECTION.setText((String)((StringProperty)this.properties.get(key)).get());
                    break;
                }
                case "icon": {
                    SECTION.setIcon((Image)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "color": {
                    SECTION.setColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "highlightColor": {
                    SECTION.setHighlightColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "textColor": {
                    SECTION.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                    break;
                }
                case "active": {
                    SECTION.setActive(((BooleanProperty)this.properties.get(key)).get());
                    break;
                }
                case "onSectionEntered": {
                    SECTION.setOnSectionEntered((EventHandler<Section.SectionEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "onSectionLeft": {
                    SECTION.setOnSectionLeft((EventHandler<Section.SectionEvent>)((EventHandler)((ObjectProperty)this.properties.get(key)).get()));
                    break;
                }
                case "styleClass": {
                    SECTION.setStyleClass((String)((StringProperty)this.properties.get(key)).get());
                }
            }
        }
        return SECTION;
    }
}

