/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.poi_trv_ti;

import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.scene.Node;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mapton.api.MPoi;
import org.mapton.api.MPoiProvider;
import org.mapton.api.MPoiStyle;
import org.mapton.poi_trv_ti.TrafficInformationManager;
import org.mapton.poi_trv_ti.WeatherView;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.trv_traffic_information.road.camera.v1.Camera;
import se.trixon.trv_traffic_information.road.parking.v1_4.Parking;
import se.trixon.trv_traffic_information.road.trafficsafetycamera.v1.TrafficSafetyCamera;
import se.trixon.trv_traffic_information.road.weatherstation.v1.Measurement;
import se.trixon.trv_traffic_information.road.weatherstation.v1.WeatherStation;

public class TrafficInfoPoiProvider
implements MPoiProvider {
    private final ResourceBundle mBundle = NbBundle.getBundle(TrafficInfoPoiProvider.class);
    private final TrafficInformationManager mManager = TrafficInformationManager.getInstance();
    private WeatherView mWeatherView;
    private final WKTReader mWktReader = new WKTReader();

    public TrafficInfoPoiProvider() {
        Platform.runLater(() -> {
            this.mWeatherView = new WeatherView();
        });
    }

    public String getName() {
        return this.mBundle.getString("name");
    }

    public ArrayList<MPoi> getPois() {
        ArrayList<MPoi> pois = new ArrayList<MPoi>();
        this.addCameras(pois);
        this.addParking(pois);
        this.addTrafficSafetyCameras(pois);
        this.addWeatherStations(pois);
        return pois;
    }

    private void addCameras(ArrayList<MPoi> pois) {
        this.mManager.getCameraGroupToPhotoUrl().clear();
        this.mManager.getResultsCamera().forEach(result -> {
            for (Camera camera : result.getCamera()) {
                try {
                    if (!camera.isActive().booleanValue()) continue;
                    try {
                        this.mManager.getCameraGroupToPhotoUrl().put(camera.getCameraGroup(), camera.getPhotoUrl());
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    MPoi poi = new MPoi();
                    poi.setDescription(camera.getDescription());
                    poi.setCategory("%s".formatted("Kameror"));
                    poi.setCategory(camera.getType());
                    poi.setColor("ff0000");
                    poi.setDisplayMarker(Boolean.valueOf(true));
                    poi.setName(camera.getName());
                    poi.setZoom(Double.valueOf(0.9));
                    poi.setExternalImageUrl(camera.getPhotoUrl() + "?type=fullsize");
                    this.setLatLonFromGeometry(poi, camera.getGeometry().getWGS84());
                    MPoiStyle style = new MPoiStyle();
                    poi.setStyle(style);
                    style.setImageUrl(this.getPlacemarkUrl(camera.getIconId()));
                    style.setLabelVisible(false);
                    pois.add(poi);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        });
    }

    private void addParking(ArrayList<MPoi> pois) {
        this.mManager.getResultsParking().forEach(result -> {
            for (Parking parking : result.getParking()) {
                try {
                    MPoi poi = new MPoi();
                    poi.setDescription(parking.getDescription());
                    poi.setCategory("%s".formatted("Parkering"));
                    poi.setColor("00ff00");
                    poi.setDisplayMarker(Boolean.valueOf(true));
                    poi.setName(parking.getName());
                    poi.setZoom(Double.valueOf(0.9));
                    this.setLatLonFromGeometry(poi, parking.getGeometry().getWGS84());
                    MPoiStyle style = new MPoiStyle();
                    poi.setStyle(style);
                    style.setImageUrl(this.getPlacemarkUrl(parking.getIconId()));
                    style.setLabelVisible(false);
                    pois.add(poi);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        });
    }

    private void addTrafficSafetyCameras(ArrayList<MPoi> pois) {
        this.mManager.getResultsTrafficSafetyCamera().forEach(result -> {
            for (TrafficSafetyCamera camera : result.getTrafficSafetyCamera()) {
                try {
                    MPoi poi = new MPoi();
                    poi.setDescription(camera.getBearing().toString());
                    poi.setCategory("%s".formatted("Trafiks\u00e4kerhetskameror"));
                    poi.setColor("00ff00");
                    poi.setDisplayMarker(Boolean.valueOf(true));
                    poi.setName(camera.getName());
                    poi.setZoom(Double.valueOf(0.9));
                    this.setLatLonFromGeometry(poi, camera.getGeometry().getWGS84());
                    MPoiStyle style = new MPoiStyle();
                    poi.setStyle(style);
                    style.setImageUrl(this.getPlacemarkUrl(camera.getIconId()));
                    style.setLabelVisible(false);
                    pois.add(poi);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        });
    }

    private void addWeatherStations(ArrayList<MPoi> pois) {
        this.mManager.getResultsWeatherStation().forEach(result -> {
            for (WeatherStation weatherStation : result.getWeatherStation()) {
                try {
                    if (weatherStation.isDeleted() != null && weatherStation.isDeleted().booleanValue() || StringUtils.endsWith((CharSequence)weatherStation.getName(), (CharSequence)" Fj\u00e4rryta")) continue;
                    MPoi poi = new MPoi();
                    poi.setCategory("%s".formatted("V\u00e4derstation"));
                    poi.setDisplayMarker(Boolean.valueOf(true));
                    poi.setName(weatherStation.getName());
                    poi.setZoom(Double.valueOf(0.9));
                    poi.setPropertyNode((Node)this.mWeatherView);
                    poi.setPropertySource((Object)weatherStation);
                    this.setLatLonFromGeometry(poi, weatherStation.getGeometry().getWGS84());
                    MPoiStyle style = new MPoiStyle();
                    poi.setStyle(style);
                    Measurement measurement = weatherStation.getMeasurement();
                    if (weatherStation.isActive().booleanValue()) {
                        style.setLabelText("%.0f\u00b0".formatted(measurement.getAir().getTemp()));
                        style.setImageUrl(this.mManager.getIconUrl(measurement.getPrecipitation()));
                        try {
                            poi.setDescription("%s %s".formatted(measurement.getPrecipitation().getAmount(), measurement.getPrecipitation().getAmountName()));
                        }
                        catch (Exception exception) {}
                    } else {
                        style.setLabelText("NODATA");
                        style.setImageUrl("%s%s.png".formatted(SystemHelper.getPackageAsPath(TrafficInfoPoiProvider.class), "precipitationNoData"));
                    }
                    style.setLabelScale(1.2);
                    style.setImageScale(FxHelper.getUIScaled((double)0.1));
                    style.setLabelVisible(true);
                    style.setImageLocation(MPoiStyle.ImageLocation.MIDDLE_CENTER);
                    pois.add(poi);
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        });
    }

    private String getPlacemarkUrl(String iconId) {
        return "https://api.trafikinfo.trafikverket.se/v2/icons/%s".formatted(iconId);
    }

    private void setLatLonFromGeometry(MPoi poi, String wkt) {
        try {
            Coordinate coordinate = this.mWktReader.read(wkt).getCoordinate();
            poi.setLatitude(Double.valueOf(coordinate.y));
            poi.setLongitude(Double.valueOf(coordinate.x));
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

