/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.poi_trv_ti;

import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MServiceKeyManager;
import org.mapton.api.MSimpleObjectStorageManager;
import org.mapton.api.Mapton;
import org.mapton.poi_trv_ti.ApiKeyProvider;
import org.mapton.poi_trv_ti.TrafficInfoPoiProvider;
import org.openide.util.Exceptions;
import se.trixon.almond.util.SystemHelper;
import se.trixon.trv_traffic_information.TrafficInformation;
import se.trixon.trv_traffic_information.road.camera.v1.RESULT;
import se.trixon.trv_traffic_information.road.weatherstation.v1.Precipitation;
import se.trixon.trv_traffic_information.road.weatherstation.v1.Wind;

public class TrafficInformationManager {
    private final File mCacheDir;
    private final ConcurrentHashMap<String, String> mCameraGroupToPhotoUrl = new ConcurrentHashMap();
    private HashMap<File, Long> mFileToTimestamp = new HashMap();
    private List<RESULT> mResultsCamera;
    private List<se.trixon.trv_traffic_information.road.parking.v1_4.RESULT> mResultsParking;
    private List<se.trixon.trv_traffic_information.road.trafficsafetycamera.v1.RESULT> mResultsTrafficSafetyCamera;
    private List<se.trixon.trv_traffic_information.road.weatherstation.v1.RESULT> mResultsWeatherStation;
    private HashMap<Service, File> mServiceToFile = new HashMap();
    private final TrafficInformation mTrafficInformation;

    public static TrafficInformationManager getInstance() {
        return Holder.INSTANCE;
    }

    private TrafficInformationManager() {
        String key = MSimpleObjectStorageManager.getInstance().getString(ApiKeyProvider.class, null);
        if (StringUtils.isBlank((CharSequence)key)) {
            key = MServiceKeyManager.getInstance().getKey("001");
        }
        this.mTrafficInformation = new TrafficInformation(key);
        this.mCacheDir = new File(Mapton.getCacheDir(), "poi/trv-ti");
        try {
            FileUtils.forceMkdir((File)this.mCacheDir);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public ConcurrentHashMap<String, String> getCameraGroupToPhotoUrl() {
        return this.mCameraGroupToPhotoUrl;
    }

    public File getFile(Service service) {
        return this.mServiceToFile.computeIfAbsent(service, k -> new File(this.mCacheDir, service.getFilename()));
    }

    public String getIconUrl(Wind wind) {
        return "%s%s.png".formatted(SystemHelper.getPackageAsPath(TrafficInfoPoiProvider.class), wind.getDirectionIconId());
    }

    public String getIconUrl(Precipitation precipitation) {
        String basename = "NoData";
        switch (precipitation.getAmountName()) {
            case "Givare saknas/Fel p\u00e5 givare": {
                break;
            }
            case "L\u00e4tt regn": {
                basename = "LightRain";
                break;
            }
            case "M\u00e5ttligt regn": {
                basename = "ModerateRain";
                break;
            }
            case "Kraftigt regn": {
                basename = "HeavyRain";
                break;
            }
            case "L\u00e4tt sn\u00f6blandat regn": {
                basename = "LightSleet";
                break;
            }
            case "M\u00e5ttligt sn\u00f6blandat regn": {
                basename = "ModerateSleet";
                break;
            }
            case "Kraftigt sn\u00f6blandat regn": {
                basename = "HeavySleet";
                break;
            }
            case "L\u00e4tt sn\u00f6fall": {
                basename = "LightSnow";
                break;
            }
            case "M\u00e5ttligt sn\u00f6fall": {
                basename = "ModerateSnow";
                break;
            }
            case "Kraftigt sn\u00f6fall": {
                basename = "HeavySnow";
                break;
            }
            case "Annan nederb\u00f6rdstyp": {
                basename = "NoData";
                break;
            }
            case "Ingen nederb\u00f6rd": {
                basename = "NoPrecipitation";
                break;
            }
            case "Ok\u00e4nd nederb\u00f6rdstyp": {
                basename = "NoData";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return "%sprecipitation%s.png".formatted(SystemHelper.getPackageAsPath(TrafficInfoPoiProvider.class), basename);
    }

    public List<RESULT> getResultsCamera() {
        File file = this.getFile(Service.CAMERA);
        if (file.exists()) {
            if (this.isOutOfDate(this.mResultsCamera, file)) {
                try {
                    this.mResultsCamera = this.mTrafficInformation.road().getCameraResults(file);
                    this.mFileToTimestamp.put(file, file.lastModified());
                }
                catch (JAXBException | IOException | InterruptedException ex) {
                    this.mResultsCamera = new ArrayList<RESULT>();
                    Exceptions.printStackTrace((Throwable)ex);
                    if (ex instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        } else {
            this.mResultsCamera = new ArrayList<RESULT>();
        }
        return this.mResultsCamera;
    }

    public List<se.trixon.trv_traffic_information.road.parking.v1_4.RESULT> getResultsParking() {
        File file = this.getFile(Service.PARKING);
        if (file.exists()) {
            if (this.isOutOfDate(this.mResultsParking, file)) {
                try {
                    this.mResultsParking = this.mTrafficInformation.road().getParkingResults(file);
                    this.mFileToTimestamp.put(file, file.lastModified());
                }
                catch (JAXBException | IOException | InterruptedException ex) {
                    this.mResultsParking = new ArrayList<se.trixon.trv_traffic_information.road.parking.v1_4.RESULT>();
                    Exceptions.printStackTrace((Throwable)ex);
                    if (ex instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        } else {
            this.mResultsParking = new ArrayList<se.trixon.trv_traffic_information.road.parking.v1_4.RESULT>();
        }
        return this.mResultsParking;
    }

    public List<se.trixon.trv_traffic_information.road.trafficsafetycamera.v1.RESULT> getResultsTrafficSafetyCamera() {
        File file = this.getFile(Service.TRAFFIC_SAFETY_CAMERA);
        if (file.exists()) {
            if (this.isOutOfDate(this.mResultsTrafficSafetyCamera, file)) {
                try {
                    this.mResultsTrafficSafetyCamera = this.mTrafficInformation.road().getTrafficSafetyCameraResults(file);
                    this.mFileToTimestamp.put(file, file.lastModified());
                }
                catch (JAXBException | IOException | InterruptedException ex) {
                    this.mResultsTrafficSafetyCamera = new ArrayList<se.trixon.trv_traffic_information.road.trafficsafetycamera.v1.RESULT>();
                    Exceptions.printStackTrace((Throwable)ex);
                    if (ex instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        } else {
            this.mResultsTrafficSafetyCamera = new ArrayList<se.trixon.trv_traffic_information.road.trafficsafetycamera.v1.RESULT>();
        }
        return this.mResultsTrafficSafetyCamera;
    }

    public List<se.trixon.trv_traffic_information.road.weatherstation.v1.RESULT> getResultsWeatherStation() {
        File file = this.getFile(Service.WEATHER_STATION);
        if (file.exists()) {
            if (this.isOutOfDate(this.mResultsWeatherStation, file)) {
                try {
                    this.mResultsWeatherStation = this.mTrafficInformation.road().getWeatherStationResults(file);
                    this.mFileToTimestamp.put(file, file.lastModified());
                }
                catch (JAXBException | IOException | InterruptedException ex) {
                    this.mResultsWeatherStation = new ArrayList<se.trixon.trv_traffic_information.road.weatherstation.v1.RESULT>();
                    Exceptions.printStackTrace((Throwable)ex);
                    if (ex instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        } else {
            this.mResultsWeatherStation = new ArrayList<se.trixon.trv_traffic_information.road.weatherstation.v1.RESULT>();
        }
        return this.mResultsWeatherStation;
    }

    public TrafficInformation getTrafficInformation() {
        return this.mTrafficInformation;
    }

    private boolean isOutOfDate(Object result, File file) {
        long lastModified = this.mFileToTimestamp.computeIfAbsent(file, k -> 0L);
        return result == null || file.lastModified() > lastModified;
    }

    private static class Holder {
        private static final TrafficInformationManager INSTANCE = new TrafficInformationManager();

        private Holder() {
        }
    }

    public static enum Service {
        CAMERA("camera.xml"),
        PARKING("parking.xml"),
        TRAFFIC_SAFETY_CAMERA("traffic_safety_camera.xml"),
        WEATHER_STATION("weather_station.xml");

        private final String mFilename;

        private Service(String filename) {
            this.mFilename = filename;
        }

        public String getFilename() {
            return this.mFilename;
        }
    }
}

