/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.poi_trv_ti;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.TileBuilder;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mapton.api.MDict;
import org.mapton.api.MGenericLoader;
import org.mapton.poi_trv_ti.TrafficInformationManager;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.trv_traffic_information.road.weatherstation.v1.Measurement;
import se.trixon.trv_traffic_information.road.weatherstation.v1.Precipitation;
import se.trixon.trv_traffic_information.road.weatherstation.v1.WeatherStation;
import se.trixon.trv_traffic_information.road.weatherstation.v1.Wind;

public class WeatherView
extends BorderPane
implements MGenericLoader<WeatherStation> {
    private static final double TILE_HEIGHT = FxHelper.getUIScaled((double)150.0);
    private static final double TILE_WIDTH = FxHelper.getUIScaled((double)150.0);
    private Tile mAirHumidityTile;
    private Tile mAirTemperatureTile;
    private final ResourceBundle mBundle = NbBundle.getBundle(WeatherView.class);
    private Tile mCameraImageTile;
    private final DateTimeFormatter mDtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH.mm");
    private final HashMap<String, Image> mIconIdToImage = new HashMap();
    private final TrafficInformationManager mManager = TrafficInformationManager.getInstance();
    private Image mNullImage;
    private Tile mPrecipitationTile;
    private Label mTimeLabel;
    private Label mTitleLabel;
    private Tile mWindTile;
    private final ZoneId mZoneOffset = ZoneOffset.systemDefault();

    public WeatherView() {
        this.createUI();
    }

    public void load(WeatherStation weatherStation) {
        FxHelper.runLater(() -> {
            Measurement measurement = weatherStation.getMeasurement();
            OffsetDateTime offsetDateTime = OffsetDateTime.parse(measurement.getMeasureTime().toString());
            this.mTitleLabel.setText("%s %d, %s".formatted(MDict.ROAD.toString(), weatherStation.getRoadNumberNumeric(), weatherStation.getName()));
            LocalDateTime measLocalDateTime = offsetDateTime.atZoneSameInstant(this.mZoneOffset).toLocalDateTime();
            this.mTimeLabel.setText(measLocalDateTime.format(this.mDtf));
            this.loadTemperature(weatherStation);
            this.loadPreciptation(weatherStation);
            this.loadHumidity(weatherStation);
            this.loadWind(weatherStation);
            this.loadImage(weatherStation);
        });
    }

    private void createUI() {
        this.mNullImage = new Pane().snapshot(null, null);
        this.mIconIdToImage.put("null", this.mNullImage);
        this.setPadding(FxHelper.getUIScaledInsets((double)8.0));
        String style = "-fx-font-weight: %s; -fx-font-style: %s; -fx-font-size: %.0fpx";
        double defaultSize = Font.getDefault().getSize();
        this.mTimeLabel = new Label();
        this.mTitleLabel = new Label();
        this.mTitleLabel.setStyle(style.formatted("bold", "normal", defaultSize * 1.2));
        this.setTop((Node)this.mTitleLabel);
        this.mAirTemperatureTile = TileBuilder.create().skinType(Tile.SkinType.FIRE_SMOKE).prefSize(TILE_WIDTH, TILE_HEIGHT).textSize(Tile.TextSize.BIGGER).minValue(-999.0).decimals(0).threshold(100.0).thresholdVisible(true).build();
        this.mPrecipitationTile = TileBuilder.create().skinType(Tile.SkinType.IMAGE_COUNTER).prefSize(2.0 * TILE_WIDTH, TILE_HEIGHT).textSize(Tile.TextSize.BIGGER).descriptionAlignment(Pos.BASELINE_LEFT).descriptionAlignment(Pos.BOTTOM_LEFT).imageMask(Tile.ImageMask.ROUND).minValue(-1.0).build();
        this.mWindTile = TileBuilder.create().skinType(Tile.SkinType.IMAGE_COUNTER).prefSize(2.0 * TILE_WIDTH, TILE_HEIGHT).textSize(Tile.TextSize.BIGGER).descriptionAlignment(Pos.BASELINE_LEFT).descriptionAlignment(Pos.BOTTOM_LEFT).imageMask(Tile.ImageMask.ROUND).build();
        this.mAirHumidityTile = TileBuilder.create().skinType(Tile.SkinType.FIRE_SMOKE).prefSize(TILE_WIDTH, TILE_HEIGHT).textSize(Tile.TextSize.BIGGER).unit("%").decimals(0).threshold(100.0).thresholdVisible(true).build();
        this.mCameraImageTile = TileBuilder.create().skinType(Tile.SkinType.IMAGE).prefSize(3.0 * TILE_WIDTH, TILE_HEIGHT * 1.2).imageMask(Tile.ImageMask.NONE).textAlignment(TextAlignment.CENTER).roundedCorners(true).build();
        GridPane gp = new GridPane();
        gp.setPadding(FxHelper.getUIScaledInsets((double)8.0));
        gp.setHgap((double)FxHelper.getUIScaled((int)8));
        gp.setVgap((double)FxHelper.getUIScaled((int)8));
        int col = 0;
        int row = 0;
        gp.add((Node)this.mTimeLabel, col, row, Integer.MAX_VALUE, 1);
        gp.add((Node)this.mAirTemperatureTile, col, ++row, 1, 1);
        gp.add((Node)this.mPrecipitationTile, ++col, row, Integer.MAX_VALUE, 1);
        col = 0;
        gp.add((Node)this.mAirHumidityTile, 0, ++row, 1, 1);
        gp.add((Node)this.mWindTile, ++col, row, Integer.MAX_VALUE, 1);
        col = 0;
        gp.add((Node)this.mCameraImageTile, 0, ++row, Integer.MAX_VALUE, 1);
        GridPane.setValignment((Node)this.mTimeLabel, (VPos)VPos.CENTER);
        GridPane.setHgrow((Node)this.mPrecipitationTile, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.mWindTile, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)this.mPrecipitationTile, (Boolean)true);
        GridPane.setFillWidth((Node)this.mWindTile, (Boolean)true);
        this.mCameraImageTile.setMaxWidth(Double.MAX_VALUE);
        double width = 33.333333333333336;
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPercentWidth(width);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPercentWidth(width * 2.0);
        gp.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        this.setCenter((Node)gp);
    }

    private void debug(Object o) {
        try {
            System.out.println(ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)ToStringStyle.JSON_STYLE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("-".repeat(20));
    }

    private void debug(WeatherStation weatherStation) {
        System.out.println("*".repeat(80));
        this.debug(weatherStation.getMeasurement().getPrecipitation());
    }

    private Image getImageForIconId(String iconId) {
        return this.mIconIdToImage.computeIfAbsent(iconId, k -> {
            ImageView imageView = new ImageView(k);
            SnapshotParameters snapshotParameters = new SnapshotParameters();
            snapshotParameters.setFill((Paint)Color.WHITESMOKE);
            WritableImage image = imageView.snapshot(snapshotParameters, null);
            return image;
        });
    }

    private String getMessage(String key) {
        try {
            return this.mBundle.getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    private void loadHumidity(WeatherStation weatherStation) {
        try {
            this.mAirHumidityTile.setValue((double)weatherStation.getMeasurement().getAir().getRelativeHumidity().floatValue());
        }
        catch (NullPointerException e) {
            this.mAirHumidityTile.setValue(-1.0);
        }
    }

    private void loadImage(WeatherStation weatherStation) {
        String url = this.mManager.getCameraGroupToPhotoUrl().getOrDefault(weatherStation.getId(), null);
        Image image = url != null ? new Image(url) : this.mNullImage;
        this.mCameraImageTile.setImage(image);
    }

    private void loadPreciptation(WeatherStation weatherStation) {
        Precipitation precipitation = weatherStation.getMeasurement().getPrecipitation();
        try {
            boolean hasValue;
            Float amount = precipitation.getAmount();
            boolean bl = hasValue = amount != null;
            if (amount != null) {
                this.mPrecipitationTile.setValue((double)amount.floatValue());
            }
            this.mPrecipitationTile.setValueVisible(hasValue);
            this.mPrecipitationTile.setUnit(hasValue ? "mm/h" : "");
            String description = precipitation.getAmountName();
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)precipitation.getType(), (CharSequence[])new CharSequence[]{"Hagel", "Underkylt regn"})) {
                description = precipitation.getType();
            }
            this.mPrecipitationTile.setDescription(this.getMessage(description));
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        this.mPrecipitationTile.setImage(this.getImageForIconId(this.mManager.getIconUrl(precipitation)));
        this.setTooltipText(this.mPrecipitationTile, precipitation);
    }

    private void loadTemperature(WeatherStation weatherStation) {
        Measurement measurement = weatherStation.getMeasurement();
        if (measurement != null) {
            boolean hasValue;
            boolean bl = hasValue = measurement.getAir() != null;
            if (hasValue) {
                this.mAirTemperatureTile.setValue((double)measurement.getAir().getTemp().floatValue());
            }
            this.mAirTemperatureTile.setValueVisible(hasValue);
            this.mAirTemperatureTile.setUnit(hasValue ? "\u00b0C" : "");
            this.setTooltipText(this.mAirTemperatureTile, measurement.getAir());
        } else {
            this.setTooltipText(this.mAirTemperatureTile, "");
        }
    }

    private void loadWind(WeatherStation weatherStation) {
        Wind wind = weatherStation.getMeasurement().getWind();
        if (wind != null) {
            boolean hasValue;
            boolean bl = hasValue = wind.getForce() != null;
            if (hasValue) {
                this.mWindTile.setValue((double)wind.getForce().floatValue());
                this.mWindTile.setDescription("%s: %.1f m/s".formatted("Max", wind.getForceMax()));
                this.mWindTile.setImage(this.getImageForIconId(this.mManager.getIconUrl(wind)));
            } else {
                this.mWindTile.setValue(-1.0);
                this.mWindTile.setDescription("");
                this.mWindTile.setImage(this.mNullImage);
            }
            this.mWindTile.setValueVisible(hasValue);
            this.mWindTile.setUnit(hasValue ? "m/s" : "");
        }
        this.setTooltipText(this.mWindTile, wind);
    }

    private void setTooltipText(Tile tile, Object o) {
        String s = null;
        if (o != null) {
            s = ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE);
        }
        tile.setTooltipText(s);
    }
}

