/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.pickerfx;

import com.dlsc.pickerfx.Picker;
import com.dlsc.pickerfx.Segment;
import com.dlsc.pickerfx.SegmentCell;
import com.dlsc.pickerfx.TimeFormat;
import com.dlsc.pickerfx.skins.LocalTimePickerSkin;
import java.time.LocalTime;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Skin;
import javafx.util.Callback;

public class LocalTimePicker
extends Picker<LocalTime> {
    private final ObjectProperty<TimeFormat> timeFormat = new SimpleObjectProperty((Object)this, "timeFormat", (Object)TimeFormat.TWENTY_FOUR_HOURS);
    private final ObjectProperty<Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>>> hourCellFactory = new SimpleObjectProperty((Object)this, "hourCellFactory", segment -> new SegmentCell());
    private final ObjectProperty<Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>>> minuteCellFactory = new SimpleObjectProperty((Object)this, "minuteCellFactory", segment -> new SegmentCell());
    private final ObjectProperty<Callback<Segment<LocalTime, Meridiem>, SegmentCell<Meridiem>>> meridiemCellFactory = new SimpleObjectProperty((Object)this, "meridiemCellFactory", segment -> new SegmentCell());

    public LocalTimePicker() {
        this.getStyleClass().add((Object)"local-time-picker");
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("local-time-picker.css").toExternalForm());
        this.setValue(LocalTime.now());
        this.setMinuteCellFactory((Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>>)((Callback)segment -> new SegmentCell<Integer>(){

            @Override
            public void update(Integer item) {
                super.update(item);
                if (item < 10) {
                    this.setText("0" + this.getText());
                }
            }
        }));
    }

    protected Skin<?> createDefaultSkin() {
        return new LocalTimePickerSkin(this);
    }

    public final TimeFormat getTimeFormat() {
        return (TimeFormat)((Object)this.timeFormat.get());
    }

    public final ObjectProperty<TimeFormat> timeFormatProperty() {
        return this.timeFormat;
    }

    public final void setTimeFormat(TimeFormat timeFormat) {
        this.timeFormat.set((Object)timeFormat);
    }

    public final Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>> getHourCellFactory() {
        return (Callback)this.hourCellFactory.get();
    }

    public final ObjectProperty<Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>>> hourCellFactoryProperty() {
        return this.hourCellFactory;
    }

    public final void setHourCellFactory(Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>> factory) {
        this.hourCellFactory.set(factory);
    }

    public final Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>> getMinuteCellFactory() {
        return (Callback)this.minuteCellFactory.get();
    }

    public final ObjectProperty<Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>>> minuteCellFactoryProperty() {
        return this.minuteCellFactory;
    }

    public final void setMinuteCellFactory(Callback<Segment<LocalTime, Integer>, SegmentCell<Integer>> factory) {
        this.minuteCellFactory.set(factory);
    }

    public final Callback<Segment<LocalTime, Meridiem>, SegmentCell<Meridiem>> getMeridiemCellFactory() {
        return (Callback)this.meridiemCellFactory.get();
    }

    public final ObjectProperty<Callback<Segment<LocalTime, Meridiem>, SegmentCell<Meridiem>>> meridiemCellFactoryProperty() {
        return this.meridiemCellFactory;
    }

    public final void setMeridiemCellFactory(Callback<Segment<LocalTime, Meridiem>, SegmentCell<Meridiem>> factory) {
        this.meridiemCellFactory.set(factory);
    }

    public static enum Meridiem {
        AM,
        PM;

    }
}

