/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.pickerfx.skins;

import com.dlsc.pickerfx.Segment;
import com.dlsc.pickerfx.SegmentCell;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import javafx.util.Duration;

public class SegmentSkin<T, S>
extends SkinBase<Segment<T, S>> {
    private boolean updatingValue;
    private double STEPS = 100.0;
    private double mouseStartX;
    private double mouseStartY;
    private final DoubleProperty location = new SimpleDoubleProperty((Object)this, "location", -1.0){

        public void set(double newValue) {
            if (!((Segment)SegmentSkin.this.getSkinnable()).isWrapItems()) {
                newValue = Math.max(0.0, Math.min(newValue, (double)(((Segment)SegmentSkin.this.getSkinnable()).getItems().size() - 1) * SegmentSkin.this.STEPS));
            }
            super.set(newValue);
        }
    };
    private boolean dragging;
    private FixerService fixerService = new FixerService(this);
    private boolean inertia;
    private Timeline timeline;

    public SegmentSkin(Segment<T, S> control) {
        super(control);
        control.addEventFilter(ScrollEvent.SCROLL, evt -> {
            if (control.isReadOnly()) {
                return;
            }
            double newLocation = control.getPicker().getOrientation().equals((Object)Orientation.VERTICAL) ? this.location.get() - evt.getDeltaY() : this.location.get() - evt.getDeltaX();
            this.scrollTo(newLocation);
            this.inertia = evt.isInertia();
            this.fixerService.restart();
            evt.consume();
        });
        control.addEventFilter(ScrollEvent.SCROLL_FINISHED, evt -> {});
        control.addEventFilter(MouseEvent.MOUSE_PRESSED, evt -> {
            if (control.isReadOnly()) {
                return;
            }
            this.mouseStartX = evt.getX();
            this.mouseStartY = evt.getY();
            this.dragging = false;
        });
        control.addEventFilter(MouseEvent.MOUSE_DRAGGED, evt -> {
            if (control.isReadOnly()) {
                return;
            }
            if (this.mouseStartY >= 0.0 || this.mouseStartX >= 0.0) {
                this.dragging = true;
                switch (control.getPicker().getOrientation()) {
                    case VERTICAL: {
                        this.scrollTo(this.location.get() - (evt.getY() - this.mouseStartY) * (this.STEPS / control.getPicker().getCellSize()));
                        break;
                    }
                    case HORIZONTAL: {
                        this.scrollTo(this.location.get() - (evt.getX() - this.mouseStartX) * (this.STEPS / control.getPicker().getCellSize()));
                    }
                }
                this.mouseStartX = evt.getX();
                this.mouseStartY = evt.getY();
            }
        });
        control.addEventFilter(MouseEvent.MOUSE_RELEASED, evt -> {
            if (this.dragging) {
                this.snapLocation();
            }
        });
        InvalidationListener layoutListener = obs -> ((Segment)this.getSkinnable()).requestLayout();
        control.getPicker().orientationProperty().addListener(layoutListener);
        control.cellFactoryProperty().addListener(layoutListener);
        control.getItems().addListener(layoutListener);
        InvalidationListener locationListener = it -> {
            this.updatingValue = true;
            try {
                control.setValue(control.getItems().get(this.getValueIndexForLocation()));
                ((Segment)this.getSkinnable()).requestLayout();
            }
            finally {
                this.updatingValue = false;
            }
        };
        this.location.addListener(locationListener);
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)control.widthProperty());
        clip.heightProperty().bind((ObservableValue)control.heightProperty());
        control.setClip((Node)clip);
        control.valueProperty().addListener(it -> {
            if (!this.updatingValue) {
                this.scrollToCurrentValue();
            }
        });
        this.scrollToCurrentValue();
    }

    private boolean isInertia() {
        return this.inertia;
    }

    private void scrollToCurrentValue() {
        if (((Segment)this.getSkinnable()).getValue() != null) {
            int index = ((Segment)this.getSkinnable()).getItems().indexOf(((Segment)this.getSkinnable()).getValue());
            this.scrollTo((double)index * this.STEPS);
        } else {
            this.scrollTo(0.0);
        }
    }

    private void snapLocation() {
        double a = this.location.get() - this.location.get() % this.STEPS;
        double b = this.location.get() > 0.0 ? a + this.STEPS : a - this.STEPS;
        if (Math.abs(a - this.location.get()) < Math.abs(b - this.location.get())) {
            this.scrollToAnimated(a);
        } else {
            this.scrollToAnimated(b);
        }
    }

    private void scrollTo(double loc) {
        this.location.set(loc);
    }

    private void scrollToAnimated(double loc) {
        if (this.timeline != null) {
            this.timeline.stop();
        }
        KeyValue keyValue = new KeyValue((WritableValue)this.location, (Object)loc, Interpolator.EASE_BOTH);
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{keyValue});
        this.timeline = new Timeline(new KeyFrame[]{keyFrame});
        this.timeline.play();
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        this.getChildren().removeIf(node -> node instanceof SegmentCell);
        Segment segment = (Segment)this.getSkinnable();
        Callback cellFactory = segment.getCellFactory();
        ObservableList items = segment.getItems();
        double cellSize = segment.getPicker().getCellSize();
        if (((Segment)this.getSkinnable()).getPicker().getOrientation().equals((Object)Orientation.VERTICAL)) {
            this.layoutChildrenVertically(contentX, contentY, contentWidth, contentHeight, segment, cellFactory, items, cellSize);
        } else {
            this.layoutChildrenHorizontally(contentX, contentY, contentWidth, contentHeight, segment, cellFactory, items, cellSize);
        }
    }

    private void layoutChildrenVertically(double contentX, double contentY, double contentWidth, double contentHeight, Segment<T, S> tumbler, Callback<Segment<T, S>, SegmentCell<S>> cellFactory, ObservableList<S> items, double cellSize) {
        double x = this.snapPosition(contentX);
        double middle = contentY + contentHeight / 2.0;
        int index = this.getIndexForLocation();
        double offset = this.getOffset();
        int i = index;
        int position = 0;
        double loc = middle;
        boolean wrapItems = ((Segment)this.getSkinnable()).isWrapItems();
        do {
            this.layoutCell(contentX, contentY, contentWidth, contentHeight, x, loc, offset, tumbler, cellFactory, items, i++, position++);
            loc += cellSize;
            if (i < items.size() || !wrapItems) continue;
            i = 0;
        } while (loc < contentHeight + cellSize && (wrapItems || i >= 0 && i < ((Segment)this.getSkinnable()).getItems().size()));
        loc = middle - cellSize;
        position = 1;
        i = index - 1;
        if (i < 0 && wrapItems) {
            i = ((Segment)this.getSkinnable()).getItems().size() - 1;
        }
        if (i >= 0) {
            do {
                this.layoutCell(contentX, contentY, contentWidth, contentHeight, x, loc, offset, tumbler, cellFactory, items, i--, position--);
                loc -= cellSize;
                if (i >= 0 || !wrapItems) continue;
                i = items.size() - 1;
            } while (loc > contentY - cellSize && (wrapItems || i >= 0 && i < ((Segment)this.getSkinnable()).getItems().size()));
        }
    }

    private void layoutChildrenHorizontally(double contentX, double contentY, double contentWidth, double contentHeight, Segment<T, S> tumbler, Callback<Segment<T, S>, SegmentCell<S>> cellFactory, ObservableList<S> items, double cellSize) {
        double y = this.snapPosition(contentY);
        double middle = contentX + contentWidth / 2.0;
        int index = this.getIndexForLocation();
        double offset = this.getOffset();
        int i = index;
        int position = 0;
        double loc = middle;
        boolean wrapItems = ((Segment)this.getSkinnable()).isWrapItems();
        do {
            this.layoutCell(contentX, contentY, contentWidth, contentHeight, loc, y, offset, tumbler, cellFactory, items, i++, position++);
            loc += cellSize;
            if (i < items.size() || !wrapItems) continue;
            i = 0;
        } while (loc < contentWidth + cellSize && (wrapItems || i >= 0 && i < ((Segment)this.getSkinnable()).getItems().size()));
        loc = middle - cellSize;
        position = 1;
        i = index - 1;
        if (i < 0 && wrapItems) {
            i = ((Segment)this.getSkinnable()).getItems().size() - 1;
        }
        if (i >= 0) {
            do {
                this.layoutCell(contentX, contentY, contentWidth, contentHeight, loc, y, offset, tumbler, cellFactory, items, i--, position--);
                loc -= cellSize;
                if (i >= 0 || !wrapItems) continue;
                i = items.size() - 1;
            } while (loc > contentX - cellSize && (wrapItems || i >= 0 && i < ((Segment)this.getSkinnable()).getItems().size()));
        }
    }

    private void layoutCell(double contentX, double contentY, double contentWidth, double contentHeight, double x, double y, double offset, Segment<T, S> segment, Callback<Segment<T, S>, SegmentCell<S>> cellFactory, ObservableList<S> items, int index, int position) {
        SegmentCell cell = (SegmentCell)((Object)cellFactory.call(segment));
        this.getChildren().add((Object)cell);
        cell.update(items.get(index));
        cell.setIndex(index);
        cell.setPosition(position);
        cell.setManaged(false);
        cell.setMouseTransparent(true);
        cell.setSelected(this.getValueIndexForLocation() == index);
        double cellSize = segment.getPicker().getCellSize();
        if (segment.getPicker().getOrientation().equals((Object)Orientation.VERTICAL)) {
            double cellLocation = this.snapPosition(y - cellSize / 2.0 - offset * cellSize);
            double middle = (contentY + contentHeight) / 2.0;
            double distance = Math.abs((cellLocation - middle + cellSize / 2.0) / cellSize);
            cell.setOpacity(1.0 - Math.min(0.9, distance * 0.3));
            cell.resizeRelocate(x, cellLocation, contentWidth, cellSize);
        } else {
            double cellLocation = this.snapPosition(x - cellSize / 2.0 - offset * cellSize);
            double middle = (contentX + contentWidth) / 2.0;
            double distance = Math.abs((cellLocation - middle + cellSize / 2.0) / cellSize);
            cell.setOpacity(1.0 - Math.min(0.9, distance * 0.3));
            cell.resizeRelocate(cellLocation, y, cellSize, contentHeight);
        }
    }

    private int getIndexForLocation() {
        int index = (int)(this.location.get() / this.STEPS) % ((Segment)this.getSkinnable()).getItems().size();
        if (index < 0) {
            index = ((Segment)this.getSkinnable()).getItems().size() + index;
        }
        return index;
    }

    private int getValueIndexForLocation() {
        int index = this.location.get() >= 0.0 ? (int)((this.location.get() + this.STEPS / 2.0) / this.STEPS) % ((Segment)this.getSkinnable()).getItems().size() : (int)((this.location.get() - this.STEPS / 2.0) / this.STEPS) % ((Segment)this.getSkinnable()).getItems().size();
        if (index < 0) {
            index = ((Segment)this.getSkinnable()).getItems().size() + index;
        }
        return index;
    }

    private double getOffset() {
        return this.location.get() % this.STEPS / this.STEPS;
    }

    static class FixerTask
    extends Task<Void> {
        private final SegmentSkin<?, ?> segmentSkin;

        FixerTask(SegmentSkin<?, ?> skin) {
            this.segmentSkin = skin;
        }

        protected Void call() throws Exception {
            Thread.sleep(this.segmentSkin.isInertia() ? 100L : 1000L);
            if (!this.isCancelled()) {
                this.segmentSkin.snapLocation();
            }
            return null;
        }
    }

    static class FixerService
    extends Service<Void> {
        private final SegmentSkin<?, ?> segmentSkin;

        FixerService(SegmentSkin<?, ?> skin) {
            this.segmentSkin = skin;
        }

        protected Task<Void> createTask() {
            return new FixerTask(this.segmentSkin);
        }
    }
}

