/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.photos;

import com.drew.imaging.ImageProcessingException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang3.StringUtils;
import org.mapton.addon.photos.PhotoInfo;
import org.mapton.addon.photos.api.MapoCollection;
import org.mapton.addon.photos.api.MapoPhoto;
import org.mapton.addon.photos.api.MapoSource;
import org.mapton.addon.photos.api.MapoSourceManager;
import org.mapton.api.MNotificationIcons;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import se.trixon.almond.nbp.NbPrint;
import se.trixon.almond.util.Dict;

public class SourceScanner {
    private MapoCollection mCurrentCollection;
    private MapoSource mCurrentSource;
    private final ArrayList<File> mFiles = new ArrayList();
    private boolean mInterrupted = false;
    private final MapoSourceManager mManager = MapoSourceManager.getInstance();
    private final NbPrint mPrint = new NbPrint(Dict.PHOTOS.toString());

    public SourceScanner() {
        this.mPrint.select();
        this.mPrint.out("BEGIN SCAN COLLECTION");
        for (MapoSource source : this.mManager.getItems()) {
            if (!source.isVisible()) continue;
            try {
                this.process(source);
                if (!this.mInterrupted) continue;
                break;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (this.mInterrupted) {
            this.mPrint.out("INTERRUPTED SCAN COLLECTION");
            NotificationDisplayer.getDefault().notify(Dict.OPERATION_INTERRUPTED.toString(), (Icon)MNotificationIcons.getWarningIcon(), Dict.PHOTOS.toString(), null, NotificationDisplayer.Priority.HIGH);
        } else {
            this.mManager.load();
            this.mPrint.out("END SCAN COLLECTION");
            NotificationDisplayer.getDefault().notify(Dict.OPERATION_COMPLETED.toString(), (Icon)MNotificationIcons.getInformationIcon(), Dict.PHOTOS.toString(), null, NotificationDisplayer.Priority.LOW);
        }
    }

    private void generateFileList(MapoSource source) throws IOException {
        this.mPrint.out(Dict.GENERATING_FILELIST.toString());
        PathMatcher pathMatcher = source.getPathMatcher();
        EnumSet<FileVisitOption> fileVisitOptions = source.isFollowLinks() ? EnumSet.of(FileVisitOption.FOLLOW_LINKS) : EnumSet.noneOf(FileVisitOption.class);
        File file = source.getDir();
        if (file.isDirectory()) {
            FileVisitor fileVisitor = new FileVisitor(pathMatcher);
            try {
                if (source.isRecursive()) {
                    Files.walkFileTree(file.toPath(), fileVisitOptions, Integer.MAX_VALUE, fileVisitor);
                } else {
                    Files.walkFileTree(file.toPath(), fileVisitOptions, 1, fileVisitor);
                }
                if (this.mInterrupted) {
                    return;
                }
            }
            catch (IOException ex) {
                this.mPrint.err(ex.toString());
            }
        } else if (file.isFile() && pathMatcher.matches(file.toPath().getFileName())) {
            this.mFiles.add(file);
        }
        if (this.mFiles.isEmpty()) {
            this.mPrint.out("EMPTY FILE LIST");
        } else {
            Collections.sort(this.mFiles);
        }
    }

    private void process(File file) {
        this.mPrint.out((Object)file);
        try {
            PhotoInfo photoInfo = new PhotoInfo(file);
            if (!photoInfo.isZeroCoordinate()) {
                MapoPhoto mapoPhoto = new MapoPhoto();
                mapoPhoto.setPath(file.getAbsolutePath());
                mapoPhoto.setLat(photoInfo.getLat());
                mapoPhoto.setLon(photoInfo.getLon());
                mapoPhoto.setDate(photoInfo.getDate());
                mapoPhoto.setAltitude(photoInfo.getAltitude());
                mapoPhoto.setBearing(photoInfo.getBearing());
                mapoPhoto.setChecksum(photoInfo.getChecksum());
                mapoPhoto.setOrientation(photoInfo.getOrientation());
                photoInfo.createThumbnail(this.mCurrentSource, new File(this.mCurrentSource.getThumbnailDir(), "%s.jpg".formatted(photoInfo.getChecksum())));
                mapoPhoto.setHeight(photoInfo.getHeight());
                mapoPhoto.setWidth(photoInfo.getWidth());
                this.mCurrentCollection.getPhotos().add(mapoPhoto);
            }
        }
        catch (ImageProcessingException | IOException ex) {
            this.mPrint.err((Object)ex);
        }
    }

    private void process(MapoSource source) throws IOException {
        this.mPrint.out("%s: %s".formatted("BEGIN SCAN", source));
        this.mFiles.clear();
        this.mCurrentSource = source;
        this.mCurrentCollection = new MapoCollection();
        this.mCurrentCollection.setId(source.getId());
        this.mCurrentCollection.setName(source.getName());
        source.isValid();
        this.generateFileList(source);
        if (!this.mInterrupted && !this.mFiles.isEmpty()) {
            this.mPrint.out("BEGIN PROCESSING PHOTOS");
            FileUtils.forceMkdir((File)source.getThumbnailDir());
            for (File file : this.mFiles) {
                this.process(file);
                try {
                    TimeUnit.NANOSECONDS.sleep(1L);
                }
                catch (InterruptedException ex) {
                    this.mInterrupted = true;
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            ArrayList<MapoPhoto> photos = this.mCurrentCollection.getPhotos();
            Collections.sort(photos, Comparator.comparing(MapoPhoto::getDate));
            try {
                this.mCurrentCollection.setDateMin(photos.get(0).getDate());
                this.mCurrentCollection.setDateMax(photos.get(photos.size() - 1).getDate());
            }
            catch (Exception e) {
                Date date = new Date();
                this.mCurrentCollection.setDateMin(date);
                this.mCurrentCollection.setDateMax(date);
            }
            this.mPrint.out("END PROCESSING PHOTOS");
        }
        source.save(this.mCurrentCollection);
        this.mPrint.out("%s: %s".formatted("SAVED", source.getCollectionFile().getAbsoluteFile()));
        this.mPrint.out("%s: %s".formatted("END SCAN", source));
    }

    public class FileVisitor
    extends SimpleFileVisitor<Path> {
        private final String[] mExcludePatterns;
        private final PathMatcher mPathMatcher;

        public FileVisitor(PathMatcher pathMatcher) {
            this.mPathMatcher = pathMatcher;
            this.mExcludePatterns = StringUtils.split((String)SourceScanner.this.mCurrentSource.getExcludePattern(), (String)"::");
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            String[] filePaths;
            SourceScanner.this.mPrint.out((Object)dir);
            if (this.mExcludePatterns != null) {
                for (String excludePattern : this.mExcludePatterns) {
                    if (!(IOCase.SYSTEM.isCaseSensitive() ? StringUtils.contains((CharSequence)dir.toString(), (CharSequence)excludePattern) : StringUtils.containsIgnoreCase((CharSequence)dir.toString(), (CharSequence)excludePattern))) continue;
                    return FileVisitResult.SKIP_SUBTREE;
                }
            }
            if ((filePaths = dir.toFile().list()) != null && filePaths.length > 0) {
                for (String fileName : filePaths) {
                    try {
                        TimeUnit.NANOSECONDS.sleep(1L);
                    }
                    catch (InterruptedException ex) {
                        SourceScanner.this.mInterrupted = true;
                        Thread.currentThread().interrupt();
                        return FileVisitResult.TERMINATE;
                    }
                    File file = new File(dir.toFile(), fileName);
                    if (!file.isFile() || !this.mPathMatcher.matches(file.toPath().getFileName())) continue;
                    boolean exclude = false;
                    if (this.mExcludePatterns != null) {
                        for (String excludePattern : this.mExcludePatterns) {
                            if (!StringUtils.contains((CharSequence)file.getAbsolutePath(), (CharSequence)excludePattern)) continue;
                            exclude = true;
                            break;
                        }
                    }
                    if (exclude) continue;
                    SourceScanner.this.mFiles.add(file);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exception) {
            SourceScanner.this.mPrint.err(exception.toString());
            return FileVisitResult.CONTINUE;
        }
    }
}

