/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.photos.api;

import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.mapton.addon.photos.api.Mapo;
import org.mapton.addon.photos.api.MapoCollection;
import org.mapton.addon.photos.api.MapoPhoto;
import org.mapton.addon.photos.api.MapoSourceManager;
import org.mapton.api.MLatLon;
import org.mapton.api.MLatLonBox;
import org.mapton.api.Mapton;

public class MapoSource {
    private transient MapoCollection mCollection = new MapoCollection();
    @SerializedName(value="descriptionString")
    private String mDescriptionString;
    @SerializedName(value="source")
    private File mDir = SystemUtils.getUserHome();
    @SerializedName(value="exclude_pattern")
    private String mExcludePattern = "";
    @SerializedName(value="file_pattern")
    private String mFilePattern = "{*.jpg,*.JPG}";
    @SerializedName(value="follow_links")
    private boolean mFollowLinks = true;
    @SerializedName(value="id")
    private Long mId;
    private final transient MapoSourceManager mManager = MapoSourceManager.getInstance();
    @SerializedName(value="name")
    private String mName;
    private transient PathMatcher mPathMatcher;
    @SerializedName(value="recursive")
    private boolean mRecursive = true;
    @SerializedName(value="thumbnail_border_color")
    private String mThumbnailBorderColor = "FFFF00";
    @SerializedName(value="thumbnail_border_size")
    private int mThumbnailBorderSize = 10;
    private transient File mThumbnailDir;
    @SerializedName(value="thumbnail_force_creation")
    private boolean mThumbnailForceCreation = false;
    @SerializedName(value="thumbnail_size")
    private int mThumbnailSize = 800;
    @SerializedName(value="visible")
    private boolean mVisible = true;

    public void fitToBounds() {
        ArrayList<MLatLon> latLons = new ArrayList<MLatLon>();
        for (MapoPhoto photo : this.getCollection().getPhotos()) {
            latLons.add(new MLatLon(photo.getLat(), photo.getLon()));
        }
        if (!latLons.isEmpty()) {
            Mapton.getEngine().fitToBounds(new MLatLonBox(latLons));
        }
    }

    public MapoCollection getCollection() {
        return this.mCollection;
    }

    public File getCollectionFile() {
        return new File(this.mManager.getCacheDir(), "%d.json".formatted(this.getId()));
    }

    public String getDescriptionString() {
        return this.mDescriptionString;
    }

    public File getDir() {
        return this.mDir;
    }

    public String getExcludePattern() {
        return this.mExcludePattern;
    }

    public String getFilePattern() {
        return this.mFilePattern;
    }

    public Long getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public PathMatcher getPathMatcher() {
        return this.mPathMatcher;
    }

    public String getThumbnailBorderColor() {
        return this.mThumbnailBorderColor;
    }

    public int getThumbnailBorderSize() {
        return this.mThumbnailBorderSize;
    }

    public File getThumbnailDir() {
        if (this.mThumbnailDir == null) {
            this.mThumbnailDir = new File(this.mManager.getCacheDir(), String.valueOf(this.getId()));
        }
        return this.mThumbnailDir;
    }

    public int getThumbnailSize() {
        return this.mThumbnailSize;
    }

    public boolean isFollowLinks() {
        return this.mFollowLinks;
    }

    public boolean isRecursive() {
        return this.mRecursive;
    }

    public boolean isThumbnailForceCreation() {
        return this.mThumbnailForceCreation;
    }

    public boolean isValid() {
        try {
            this.mPathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + this.mFilePattern);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public MapoCollection loadCollection() throws IOException {
        try {
            return (MapoCollection)Mapo.getGson().fromJson(FileUtils.readFileToString((File)this.getCollectionFile(), (String)"utf-8"), MapoCollection.class);
        }
        catch (FileNotFoundException e) {
            return new MapoCollection();
        }
    }

    public void save(MapoCollection collection) throws IOException {
        FileUtils.write((File)this.getCollectionFile(), (CharSequence)Mapo.getGson().toJson((Object)collection), (String)"utf-8");
    }

    public void setCollection(MapoCollection collection) {
        this.mCollection = collection;
    }

    public void setDescriptionString(String descriptionString) {
        this.mDescriptionString = descriptionString;
    }

    public void setDir(File dir) {
        this.mDir = dir;
    }

    public void setExcludePattern(String excludePattern) {
        this.mExcludePattern = excludePattern;
    }

    public void setFilePattern(String filePattern) {
        this.mFilePattern = filePattern;
    }

    public void setFollowLinks(boolean followLinks) {
        this.mFollowLinks = followLinks;
    }

    public void setId(Long id) {
        this.mId = id;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.mPathMatcher = pathMatcher;
    }

    public void setRecursive(boolean recursive) {
        this.mRecursive = recursive;
    }

    public void setThumbnailBorderColor(String thumbnailBorderColor) {
        this.mThumbnailBorderColor = thumbnailBorderColor;
    }

    public void setThumbnailBorderSize(int thumbnailBorderSize) {
        this.mThumbnailBorderSize = thumbnailBorderSize;
    }

    public void setThumbnailForceCreation(boolean thumbnailForceCreation) {
        this.mThumbnailForceCreation = thumbnailForceCreation;
    }

    public void setThumbnailSize(int thumbnailSize) {
        this.mThumbnailSize = thumbnailSize;
    }

    public void setVisible(boolean visible) {
        this.mVisible = visible;
    }

    public String toString() {
        return "%s (%d)".formatted(this.mName, this.getCollection().getPhotos().size());
    }
}

