/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.photos.api;

import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.mapton.addon.photos.api.Mapo;
import org.mapton.addon.photos.api.MapoSource;
import org.mapton.addon.photos.ui.SourcePanel;
import org.mapton.api.Mapton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.swing.SwingHelper;

public class MapoSourceManager {
    private File mCacheDir;
    private File mConfigDir;
    private ObjectProperty<ObservableList<MapoSource>> mItems = new SimpleObjectProperty();
    private File mSourcesFile;

    public static MapoSourceManager getInstance() {
        return Holder.INSTANCE;
    }

    private MapoSourceManager() {
        this.mItems.setValue((Object)FXCollections.observableArrayList());
    }

    public void edit(MapoSource aSource) {
        SwingUtilities.invokeLater(() -> {
            boolean add;
            MapoSource newSource = aSource;
            boolean bl = add = aSource == null;
            if (add) {
                newSource = new MapoSource();
                newSource.setId(System.currentTimeMillis());
            }
            MapoSource source = newSource;
            SourcePanel sourcePanel = new SourcePanel();
            DialogDescriptor d = new DialogDescriptor((Object)sourcePanel, Dict.SOURCE.toString());
            sourcePanel.setNotifyDescriptor((NotifyDescriptor)d);
            sourcePanel.initFx(() -> sourcePanel.load(source));
            sourcePanel.setPreferredSize(SwingHelper.getUIScaledDim((int)600, (int)400));
            if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)d)) {
                Platform.runLater(() -> {
                    sourcePanel.save(source);
                    if (add) {
                        ((ObservableList)this.mItems.get()).add((Object)source);
                    }
                    FXCollections.sort((ObservableList)((ObservableList)this.mItems.get()), (o1, o2) -> o1.getName().compareTo(o2.getName()));
                });
            }
        });
    }

    public File getCacheDir() {
        if (this.mCacheDir == null) {
            this.mCacheDir = new File(Mapton.getCacheDir(), "photos");
        }
        return this.mCacheDir;
    }

    public File getConfigDir() {
        if (this.mConfigDir == null) {
            this.mConfigDir = new File(Mapton.getConfigDir(), "photos");
        }
        return this.mConfigDir;
    }

    public ObservableList<MapoSource> getItems() {
        return (ObservableList)this.mItems.get();
    }

    public LocalDate getMaxDate() {
        LocalDate localDate = LocalDate.MIN;
        for (MapoSource source : (ObservableList)this.mItems.get()) {
            if (!source.isVisible()) continue;
            try {
                LocalDate collectionDate = source.getCollection().getDateMax().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                if (!collectionDate.isAfter(localDate)) continue;
                localDate = collectionDate;
            }
            catch (NullPointerException nullPointerException) {}
        }
        if (localDate.isEqual(LocalDate.MIN)) {
            localDate = LocalDate.of(2099, 12, 31);
        }
        return localDate;
    }

    public LocalDate getMinDate() {
        LocalDate localDate = LocalDate.MAX;
        for (MapoSource source : (ObservableList)this.mItems.get()) {
            if (!source.isVisible()) continue;
            try {
                LocalDate collectionDate = source.getCollection().getDateMin().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                if (!collectionDate.isBefore(localDate)) continue;
                localDate = collectionDate;
            }
            catch (NullPointerException nullPointerException) {}
        }
        if (localDate.isEqual(LocalDate.MAX)) {
            localDate = LocalDate.of(1900, 1, 1);
        }
        return localDate;
    }

    public final ObjectProperty<ObservableList<MapoSource>> itemsProperty() {
        if (this.mItems == null) {
            this.mItems = new SimpleObjectProperty((Object)this, "items");
        }
        return this.mItems;
    }

    public void load() {
        ArrayList loadedItems = new ArrayList();
        try {
            if (this.getSourcesFile().isFile()) {
                loadedItems = (ArrayList)Mapo.getGson().fromJson(FileUtils.readFileToString((File)this.getSourcesFile(), (String)"utf-8"), new TypeToken<ArrayList<MapoSource>>(){}.getType());
                for (MapoSource source : loadedItems) {
                    try {
                        source.setCollection(source.loadCollection());
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        catch (JsonSyntaxException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        ArrayList items = loadedItems;
        Platform.runLater(() -> {
            ((ObservableList)this.mItems.get()).setAll((Collection)items);
            Mapton.getGlobalState().put("photos.source_updated", (Object)this);
        });
    }

    public void removeAll(MapoSource ... mapoSources) {
        ((ObservableList)this.mItems.get()).removeAll((Object[])mapoSources);
    }

    public void save() throws IOException {
        FileUtils.writeStringToFile((File)this.getSourcesFile(), (String)Mapo.getGson().toJson(this.mItems.get()), (String)"utf-8");
    }

    public void sourceExport(File file, ArrayList<MapoSource> selectedSources) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)Mapo.getGson().toJson(selectedSources), (String)"utf-8");
    }

    public void sourceImport(File file) throws IOException {
        String json = FileUtils.readFileToString((File)file, (String)"utf-8");
        ArrayList sources = (ArrayList)Mapo.getGson().fromJson(json, new TypeToken<ArrayList<MapoSource>>(){}.getType());
        Platform.runLater(() -> {
            ((ObservableList)this.mItems.get()).addAll((Collection)sources);
            FXCollections.sort((ObservableList)((ObservableList)this.mItems.get()), (o1, o2) -> o1.getName().compareTo(o2.getName()));
        });
    }

    private File getSourcesFile() {
        if (this.mSourcesFile == null) {
            this.mSourcesFile = new File(this.getConfigDir(), "sources.json");
        }
        return this.mSourcesFile;
    }

    private static class Holder {
        private static final MapoSourceManager INSTANCE = new MapoSourceManager();

        private Holder() {
        }
    }
}

