/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.photos.ui;

import java.util.ResourceBundle;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.mapton.addon.photos.Options;
import org.mapton.addon.photos.api.Mapo;
import org.mapton.addon.photos.api.MapoSettings;
import org.mapton.api.Mapton;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.fx.FxHelper;

public class OptionsView
extends BorderPane {
    private final ResourceBundle mBundle = SystemHelper.getBundle(OptionsView.class, (String)"Bundle");
    private final CheckBox mDrawGapCheckBox = new CheckBox(this.mBundle.getString("TabPath.drawGapCheckBox"));
    private final CheckBox mDrawTrackCheckBox = new CheckBox(this.mBundle.getString("TabPath.drawTrackCheckBox"));
    private final ColorPicker mGapColorPicker = new ColorPicker();
    private final Mapo mMapo = Mapo.getInstance();
    private final Options mOptions = Options.getInstance();
    private VBox mRoot;
    private final RadioButton mSplitByDayRadioButton = new RadioButton(Dict.Time.DAY.toString());
    private final RadioButton mSplitByHourRadioButton = new RadioButton(Dict.Time.HOUR.toString());
    private final RadioButton mSplitByMonthRadioButton = new RadioButton(Dict.Time.MONTH.toString());
    private final RadioButton mSplitByNoneRadioButton = new RadioButton(Dict.DO_NOT_SPLIT.toString());
    private final RadioButton mSplitByWeekRadioButton = new RadioButton(Dict.Time.WEEK.toString());
    private final RadioButton mSplitByYearRadioButton = new RadioButton(Dict.Time.YEAR.toString());
    private final ToggleGroup mToggleGroup = new ToggleGroup();
    private final ColorPicker mTrackColorPicker = new ColorPicker();
    private final Spinner<Double> mWidthSpinner = new Spinner(1.0, 10.0, 1.0, 0.1);

    public OptionsView() {
        this.createUI();
        this.load();
        this.initListeners();
    }

    private void createUI() {
        this.mRoot = new VBox();
        VBox trackBox = new VBox();
        Label widthLabel = new Label(Dict.Geometry.WIDTH.toString());
        Label splitByLabel = new Label(Dict.SPLIT_BY.toString());
        Label gapColorLabel = new Label(this.mBundle.getString("TabPath.colorGap"));
        Label trackColorLabel = new Label(this.mBundle.getString("TabPath.colorTrack"));
        this.mWidthSpinner.setEditable(true);
        FxHelper.autoCommitSpinners((Spinner[])new Spinner[]{this.mWidthSpinner});
        this.mSplitByHourRadioButton.setToggleGroup(this.mToggleGroup);
        this.mSplitByDayRadioButton.setToggleGroup(this.mToggleGroup);
        this.mSplitByWeekRadioButton.setToggleGroup(this.mToggleGroup);
        this.mSplitByMonthRadioButton.setToggleGroup(this.mToggleGroup);
        this.mSplitByYearRadioButton.setToggleGroup(this.mToggleGroup);
        this.mSplitByNoneRadioButton.setToggleGroup(this.mToggleGroup);
        trackBox.getChildren().addAll((Object[])new Node[]{widthLabel, this.mWidthSpinner, trackColorLabel, this.mTrackColorPicker, gapColorLabel, this.mGapColorPicker, splitByLabel, this.mSplitByHourRadioButton, this.mSplitByDayRadioButton, this.mSplitByWeekRadioButton, this.mSplitByMonthRadioButton, this.mSplitByYearRadioButton, this.mSplitByNoneRadioButton});
        trackBox.disableProperty().bind((ObservableValue)this.mDrawTrackCheckBox.selectedProperty().or((ObservableBooleanValue)this.mDrawGapCheckBox.selectedProperty()).not());
        this.mRoot.getChildren().addAll((Object[])new Node[]{this.mDrawTrackCheckBox, this.mDrawGapCheckBox, trackBox});
        FxHelper.setPadding((Insets)new Insets(8.0, 0.0, 0.0, 0.0), (Region[])new Region[]{this.mDrawTrackCheckBox, this.mDrawGapCheckBox, widthLabel, trackColorLabel, gapColorLabel, splitByLabel, this.mSplitByHourRadioButton, this.mSplitByDayRadioButton, this.mSplitByWeekRadioButton, this.mSplitByMonthRadioButton, this.mSplitByYearRadioButton, this.mSplitByNoneRadioButton});
        this.mRoot.setPadding(new Insets(8.0));
        this.setCenter((Node)this.mRoot);
    }

    private void initListeners() {
        EventHandler event = evt -> this.save();
        this.initListeners((Pane)this.mRoot, (EventHandler<ActionEvent>)event);
        this.mWidthSpinner.valueProperty().addListener((ov, t, t1) -> event.handle(null));
    }

    private void initListeners(Pane pane, EventHandler<ActionEvent> event) {
        for (Node node : pane.getChildren()) {
            if (node instanceof Pane) {
                Pane pane2 = (Pane)node;
                this.initListeners(pane2, event);
                continue;
            }
            if (node instanceof ButtonBase) {
                ButtonBase buttonBase = (ButtonBase)node;
                buttonBase.setOnAction(event);
                continue;
            }
            if (!(node instanceof ComboBoxBase)) continue;
            ComboBoxBase comboBoxBase = (ComboBoxBase)node;
            comboBoxBase.setOnAction(event);
        }
    }

    private void load() {
        MapoSettings settings = this.mMapo.getSettings();
        this.mDrawTrackCheckBox.setSelected(settings.isPlotTracks());
        this.mDrawGapCheckBox.setSelected(settings.isPlotGaps());
        this.mWidthSpinner.getValueFactory().setValue((Object)settings.getWidth());
        Color colorTrack = Color.RED;
        try {
            colorTrack = FxHelper.colorFromHexRGBA((String)settings.getColorTrack());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mTrackColorPicker.setValue((Object)colorTrack);
        Color colorGap = Color.BLACK;
        try {
            colorGap = FxHelper.colorFromHexRGBA((String)settings.getColorGap());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mGapColorPicker.setValue((Object)colorGap);
        (switch (settings.getSplitBy()) {
            case MapoSettings.SplitBy.HOUR -> this.mSplitByHourRadioButton;
            case MapoSettings.SplitBy.DAY -> this.mSplitByDayRadioButton;
            case MapoSettings.SplitBy.WEEK -> this.mSplitByWeekRadioButton;
            case MapoSettings.SplitBy.MONTH -> this.mSplitByMonthRadioButton;
            case MapoSettings.SplitBy.YEAR -> this.mSplitByYearRadioButton;
            case MapoSettings.SplitBy.NONE -> this.mSplitByNoneRadioButton;
            default -> throw new AssertionError();
        }).setSelected(true);
    }

    private void save() {
        MapoSettings settings = this.mMapo.getSettings();
        settings.setPlotTracks(this.mDrawTrackCheckBox.isSelected());
        settings.setPlotGaps(this.mDrawGapCheckBox.isSelected());
        settings.setWidth((Double)this.mWidthSpinner.getValue());
        settings.setColorGap(FxHelper.colorToHexRGB((Color)((Color)this.mGapColorPicker.getValue())));
        settings.setColorTrack(FxHelper.colorToHexRGB((Color)((Color)this.mTrackColorPicker.getValue())));
        MapoSettings.SplitBy splitBy = null;
        Toggle toggle = this.mToggleGroup.getSelectedToggle();
        if (toggle == this.mSplitByHourRadioButton) {
            splitBy = MapoSettings.SplitBy.HOUR;
        } else if (toggle == this.mSplitByDayRadioButton) {
            splitBy = MapoSettings.SplitBy.DAY;
        } else if (toggle == this.mSplitByWeekRadioButton) {
            splitBy = MapoSettings.SplitBy.WEEK;
        } else if (toggle == this.mSplitByMonthRadioButton) {
            splitBy = MapoSettings.SplitBy.MONTH;
        } else if (toggle == this.mSplitByYearRadioButton) {
            splitBy = MapoSettings.SplitBy.YEAR;
        } else if (toggle == this.mSplitByNoneRadioButton) {
            splitBy = MapoSettings.SplitBy.NONE;
        }
        settings.setSplitBy(splitBy);
        this.mOptions.put("settings", Mapo.getGson().toJson((Object)settings));
        Mapton.getGlobalState().put("photos.settings_updated", (Object)settings);
    }
}

