/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.photos.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import org.controlsfx.control.action.Action;
import org.mapton.addon.photos.ui.SourceFileAction;
import org.mapton.api.FileChooserHelper;
import org.mapton.api.MNotificationIcons;
import org.mapton.api.Mapton;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxActionSwing;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class SourceFileExportAction
extends SourceFileAction {
    @Override
    public Action getAction() {
        FxActionSwing action = new FxActionSwing(Dict.EXPORT.toString(), () -> {
            String dialogTitle;
            JFileChooser fileChooser;
            ArrayList selectedSources = this.mManager.getItems().stream().filter(source -> source.isVisible()).collect(Collectors.toCollection(ArrayList::new));
            if (!selectedSources.isEmpty() && (fileChooser = this.mFileChooserBuilder.setTitle(dialogTitle = "%s %s".formatted(Dict.EXPORT.toString(), Dict.SOURCES.toString().toLowerCase())).setSelectionApprover(FileChooserHelper.getFileExistSelectionApprover((Component)Almond.getFrame())).createFileChooser()).showSaveDialog(Almond.getFrame()) == 0) {
                new Thread(() -> {
                    File file = FileChooserHelper.getFileWithProperExt((JFileChooser)fileChooser);
                    try {
                        this.mManager.sourceExport(file, selectedSources);
                        NotificationDisplayer.getDefault().notify(Dict.OPERATION_COMPLETED.toString(), (Icon)MNotificationIcons.getInformationIcon(), dialogTitle, null, NotificationDisplayer.Priority.LOW);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }, this.getClass().getCanonicalName()).start();
            }
        });
        action.setGraphic((Node)MaterialIcon._Content.SAVE.getImageView(Mapton.getIconSizeToolBarInt()));
        return action;
    }
}

