/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.photos.ui;

import java.io.File;
import java.io.IOException;
import javafx.scene.Node;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import org.controlsfx.control.action.Action;
import org.mapton.addon.photos.ui.SourceFileAction;
import org.mapton.api.MNotificationIcons;
import org.mapton.api.Mapton;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxActionSwing;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class SourceFileImportAction
extends SourceFileAction {
    @Override
    public Action getAction() {
        FxActionSwing action = new FxActionSwing(Dict.IMPORT.toString(), () -> {
            String dialogTitle = "%s %s".formatted(Dict.IMPORT.toString(), Dict.SOURCES.toString().toLowerCase());
            JFileChooser fileChooser = this.mFileChooserBuilder.setTitle(dialogTitle).setSelectionApprover(null).createFileChooser();
            if (fileChooser.showOpenDialog(Almond.getFrame()) == 0) {
                new Thread(() -> {
                    File file = fileChooser.getSelectedFile();
                    try {
                        this.mManager.sourceImport(file);
                        NotificationDisplayer.getDefault().notify(Dict.OPERATION_COMPLETED.toString(), (Icon)MNotificationIcons.getInformationIcon(), dialogTitle, null, NotificationDisplayer.Priority.LOW);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }, this.getClass().getCanonicalName()).start();
            }
        });
        action.setGraphic((Node)MaterialIcon._File.FOLDER_OPEN.getImageView(Mapton.getIconSizeToolBarInt()));
        return action;
    }
}

