/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.addon.photos.ui;

import java.util.ResourceBundle;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import org.mapton.addon.photos.api.MapoSource;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.fx.control.FileChooserPane;

public class SourceView
extends VBox {
    private final ResourceBundle mBundle;
    private TextField mDescTextField;
    private final NotifyDescriptor mNotifyDescriptor;
    private TextField mExcludeTextField;
    private TextField mFilePatternField;
    private CheckBox mLinksCheckBox;
    private TextField mNameTextField;
    private CheckBox mRecursiveCheckBox;
    private FileChooserPane mSourceChooser;
    private Spinner<Integer> mThumbnailBorderSizeSpinner;
    private Spinner<Integer> mThumbnailSizeSpinner;
    private CheckBox mThumnailForceCreation;
    private HBox mhBox;
    private ColorPicker mColorPicker;

    public SourceView(NotifyDescriptor notifyDescriptor) {
        this.mNotifyDescriptor = notifyDescriptor;
        this.mBundle = NbBundle.getBundle(SourceView.class);
        this.createUI();
    }

    public void load(MapoSource source) {
        this.mNameTextField.setText(source.getName());
        this.mDescTextField.setText(source.getDescriptionString());
        this.mSourceChooser.setPath(source.getDir());
        this.mExcludeTextField.setText(source.getExcludePattern());
        this.mFilePatternField.setText(source.getFilePattern());
        this.mRecursiveCheckBox.setSelected(source.isRecursive());
        this.mLinksCheckBox.setSelected(source.isFollowLinks());
        this.mThumnailForceCreation.setSelected(source.isThumbnailForceCreation());
        this.mThumbnailSizeSpinner.getValueFactory().setValue((Object)source.getThumbnailSize());
        this.mThumbnailBorderSizeSpinner.getValueFactory().setValue((Object)source.getThumbnailBorderSize());
        Color color = Color.YELLOW;
        try {
            color = FxHelper.colorFromHexRGBA((String)source.getThumbnailBorderColor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mColorPicker.setValue((Object)color);
    }

    public void save(MapoSource source) {
        source.setName(this.mNameTextField.getText());
        source.setDescriptionString(this.mDescTextField.getText());
        source.setDir(this.mSourceChooser.getPath());
        source.setExcludePattern(this.mExcludeTextField.getText());
        source.setFilePattern(this.mFilePatternField.getText());
        source.setRecursive(this.mRecursiveCheckBox.isSelected());
        source.setFollowLinks(this.mLinksCheckBox.isSelected());
        source.setThumbnailForceCreation(this.mThumnailForceCreation.isSelected());
        source.setThumbnailSize((Integer)this.mThumbnailSizeSpinner.getValue());
        source.setThumbnailBorderSize((Integer)this.mThumbnailBorderSizeSpinner.getValue());
        source.setThumbnailBorderColor(FxHelper.colorToHexRGB((Color)((Color)this.mColorPicker.getValue())));
    }

    private void createUI() {
        this.mhBox = new HBox(8.0);
        this.mNameTextField = new TextField();
        this.mDescTextField = new TextField();
        this.mExcludeTextField = new TextField();
        this.mFilePatternField = new TextField();
        this.mLinksCheckBox = new CheckBox(Dict.FOLLOW_LINKS.toString());
        this.mRecursiveCheckBox = new CheckBox(Dict.SUBDIRECTORIES.toString());
        this.mSourceChooser = new FileChooserPane(Dict.SELECT.toString(), Dict.IMAGE_DIRECTORY.toString(), FileChooserPane.ObjectMode.DIRECTORY, SelectionMode.SINGLE);
        this.mThumnailForceCreation = new CheckBox(this.mBundle.getString("TabSource.forceThumbnail"));
        Label nameLabel = new Label(Dict.NAME.toString());
        Label descLabel = new Label(Dict.DESCRIPTION.toString());
        Label filePatternLabel = new Label(Dict.FILE_PATTERN.toString());
        Label excludeLabel = new Label(this.mBundle.getString("TabSource.excludeLabel"));
        Label thumbnailLabel = new Label(Dict.IMAGE_SIZE.toString());
        Label borderSizeLabel = new Label(this.mBundle.getString("TabSource.borderSizeLabel"));
        Label colorLabel = new Label(Dict.COLOR.toString());
        this.mExcludeTextField.setTooltip(new Tooltip(this.mBundle.getString("TabSource.excludeTextField.toolTip")));
        this.mColorPicker = new ColorPicker();
        this.mThumbnailBorderSizeSpinner = new Spinner(0, 20, 2, 1);
        this.mThumbnailSizeSpinner = new Spinner(100, 1200, 250, 10);
        this.mThumbnailSizeSpinner.setEditable(true);
        this.mThumbnailBorderSizeSpinner.setEditable(true);
        FxHelper.autoCommitSpinners((Spinner[])new Spinner[]{this.mThumbnailBorderSizeSpinner, this.mThumbnailSizeSpinner});
        GridPane thumbGridPane = new GridPane();
        thumbGridPane.addColumn(0, new Node[]{thumbnailLabel, this.mThumbnailSizeSpinner});
        thumbGridPane.addColumn(1, new Node[]{borderSizeLabel, this.mThumbnailBorderSizeSpinner});
        thumbGridPane.addColumn(2, new Node[]{colorLabel, this.mColorPicker});
        this.mhBox.getChildren().addAll((Object[])new Node[]{this.mRecursiveCheckBox, this.mLinksCheckBox, this.mThumnailForceCreation});
        FxHelper.setPadding((Insets)FxHelper.getUIScaledInsets((double)8.0, (double)0.0, (double)0.0, (double)0.0), (Region[])new Region[]{descLabel, this.mSourceChooser, filePatternLabel, excludeLabel, this.mhBox, thumbGridPane});
        FxHelper.setMargin((Insets)FxHelper.getUIScaledInsets((double)0.0, (double)0.0, (double)0.0, (double)16.0), (Region[])new Region[]{borderSizeLabel, this.mThumbnailBorderSizeSpinner, colorLabel, this.mColorPicker});
        this.getChildren().addAll((Object[])new Node[]{nameLabel, this.mNameTextField, descLabel, this.mDescTextField, this.mSourceChooser, filePatternLabel, this.mFilePatternField, excludeLabel, this.mExcludeTextField, this.mhBox, thumbGridPane});
        this.setPadding(FxHelper.getUIScaledInsets((double)8.0, (double)16.0, (double)0.0, (double)16.0));
        this.initValidation();
    }

    private void initValidation() {
        String text_is_required = "Text is required";
        boolean indicateRequired = false;
        ValidationSupport validationSupport = new ValidationSupport();
        Validator emptyValidator = Validator.createEmptyValidator((String)"Text is required");
        validationSupport.registerValidator((Control)this.mNameTextField, indicateRequired, emptyValidator);
        validationSupport.validationResultProperty().addListener((observable, oldValue, newValue) -> this.mNotifyDescriptor.setValid(validationSupport.isInvalid() == false));
        validationSupport.initInitialDecoration();
    }
}

