/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.filesystems.FileChooserBuilder;
import se.trixon.almond.util.Dict;

public class FileChooserHelper {
    private static final HashMap<String, FileNameExtensionFilter> sExtensionFilters = new HashMap();

    public static File getFileWithProperExt(JFileChooser fileChooser) {
        File file = fileChooser.getSelectedFile();
        FileNameExtensionFilter fileNameExtensionFilter = (FileNameExtensionFilter)fileChooser.getFileFilter();
        if (fileNameExtensionFilter.accept(file)) {
            return file;
        }
        String[] extensions = fileNameExtensionFilter.getExtensions();
        Object suffix = file.getName().endsWith(".") ? extensions[0] : "." + extensions[0];
        file = new File(file.getAbsolutePath() + (String)suffix);
        return file;
    }

    public static HashMap<String, FileNameExtensionFilter> getExtensionFilters() {
        return sExtensionFilters;
    }

    public static FileChooserBuilder.SelectionApprover getFileExistOpenSelectionApprover(Component parentComponent) {
        FileChooserBuilder.SelectionApprover selectionApprover = selection -> selection != null && selection.length > 0 && selection[0].isFile();
        return selectionApprover;
    }

    public static FileChooserBuilder.SelectionApprover getFileExistSelectionApprover(Component parentComponent) {
        FileChooserBuilder.SelectionApprover selectionApprover = selection -> {
            File file = selection[0];
            if (file.exists()) {
                int result = JOptionPane.showConfirmDialog(parentComponent, Dict.Dialog.MESSAGE_FILE_EXISTS.toString().formatted(file.getAbsolutePath()), Dict.Dialog.TITLE_FILE_EXISTS.toString(), 0);
                return result != 1;
            }
            return true;
        };
        return selectionApprover;
    }
}

