/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import com.google.gson.annotations.SerializedName;
import java.sql.Timestamp;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MLatLon;
import org.mapton.api.MLatLonBox;
import org.mapton.api.MObject;

public class MBookmark
extends MObject {
    @SerializedName(value="category")
    private String mCategory = "";
    @SerializedName(value="color")
    private String mColor = "";
    @SerializedName(value="description")
    private String mDescription = "";
    @SerializedName(value="display_marker")
    private Boolean mDisplayMarker;
    private transient Long mId;
    private transient MLatLon mLatLon;
    @SerializedName(value="lanLonBox")
    private MLatLonBox mLatLonBox;
    @SerializedName(value="latitude")
    private Double mLatitude;
    @SerializedName(value="longitude")
    private Double mLongitude;
    @SerializedName(value="name")
    private String mName = "";
    @SerializedName(value="time_created")
    private transient Timestamp mTimeCreated;
    @SerializedName(value="time_modified")
    private transient Timestamp mTimeModified;
    @SerializedName(value="zoom")
    private Double mZoom;
    @SerializedName(value="url")
    private String mUrl;

    public MBookmark() {
        this.setDisplayMarker(true);
    }

    public String getCategory() {
        return this.mCategory;
    }

    public String getColor() {
        return StringUtils.defaultString((String)this.mColor, (String)"FFFF00");
    }

    public String getDescription() {
        return this.mDescription;
    }

    public Long getId() {
        return this.mId;
    }

    public MLatLon getLatLon() {
        if (this.mLatLon == null) {
            this.mLatLon = new MLatLon(this.getLatitude(), this.getLongitude());
        }
        return this.mLatLon;
    }

    public MLatLonBox getLatLonBox() {
        return this.mLatLonBox;
    }

    public Double getLatitude() {
        return this.mLatitude;
    }

    public Double getLongitude() {
        return this.mLongitude;
    }

    public String getName() {
        return this.mName;
    }

    public Timestamp getTimeCreated() {
        return this.mTimeCreated;
    }

    public Timestamp getTimeModified() {
        return this.mTimeModified;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public Double getZoom() {
        return this.mZoom;
    }

    public Boolean isCategory() {
        return !ObjectUtils.allNotNull((Object[])new Object[]{this.getLatitude(), this.getLongitude()});
    }

    public Boolean isDisplayMarker() {
        return this.mDisplayMarker;
    }

    public void setCategory(String category) {
        this.mCategory = category;
    }

    public void setColor(String color) {
        this.mColor = color;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public void setDisplayMarker(Boolean displayMarker) {
        this.mDisplayMarker = displayMarker;
    }

    public void setId(Long id) {
        this.mId = id;
    }

    public void setLatLon(MLatLon latLon) {
        this.mLatLon = latLon;
    }

    public void setLatLonBox(MLatLonBox latLonBox) {
        this.mLatLonBox = latLonBox;
    }

    public void setLatitude(Double latitude) {
        this.mLatitude = latitude;
    }

    public void setLongitude(Double longitude) {
        this.mLongitude = longitude;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setTimeCreated(Timestamp timeCreated) {
        this.mTimeCreated = timeCreated;
    }

    public void setTimeModified(Timestamp timeModified) {
        this.mTimeModified = timeModified;
    }

    public void setUrl(String url) {
        this.mUrl = url;
    }

    public void setZoom(Double zoom) {
        this.mZoom = zoom;
    }
}

