/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.commons.lang3.StringUtils;
import org.geotools.referencing.CRS;
import org.mapton.api.GeoToolsCooTrans;
import org.mapton.api.MCooTrans;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import se.trixon.almond.util.SystemHelper;

public class MCrsManager {
    private static final Logger LOGGER = Logger.getLogger(MCrsManager.class.getName());
    private final String KEY_SELECTED = "crs.selected";
    private final ArrayList<CoordinateReferenceSystem> mAllSystems = new ArrayList();
    private final ObjectProperty<ObservableList<MCooTrans>> mItemsProperty = new SimpleObjectProperty();
    private final Preferences mPreferences = NbPreferences.forModule(MCrsManager.class);
    private final ObjectProperty<CoordinateReferenceSystem> mSelectedSystemProperty = new SimpleObjectProperty();
    private final ObservableList<CoordinateReferenceSystem> mSelectedSystems = FXCollections.observableArrayList();

    public static MCrsManager getInstance() {
        return Holder.INSTANCE;
    }

    private MCrsManager() {
        this.mItemsProperty.setValue((Object)FXCollections.observableArrayList());
        new Thread(() -> {
            this.init();
            this.initListeners();
            this.updateProviders();
        }).start();
    }

    public ArrayList<CoordinateReferenceSystem> getAllSystems() {
        return this.mAllSystems;
    }

    public final ObservableList<MCooTrans> getItems() {
        return (ObservableList)this.mItemsProperty.get();
    }

    public CoordinateReferenceSystem getSelectedSystem() {
        return (CoordinateReferenceSystem)this.mSelectedSystemProperty.get();
    }

    public ObservableList<CoordinateReferenceSystem> getSelectedSystems() {
        return this.mSelectedSystems;
    }

    public final ObjectProperty<ObservableList<MCooTrans>> itemsProperty() {
        return this.mItemsProperty;
    }

    public void save(ObservableList<CoordinateReferenceSystem> coordinateReferenceSystems) {
        StringBuilder sb = new StringBuilder();
        for (CoordinateReferenceSystem crs : coordinateReferenceSystems) {
            sb.append("%s\n".formatted(CRS.toSRS((CoordinateReferenceSystem)crs)));
        }
        this.mPreferences.put("crs.selected", sb.toString());
        this.mSelectedSystems.setAll(coordinateReferenceSystems);
        this.updateProviders();
    }

    public ObjectProperty<CoordinateReferenceSystem> selectedSystemProperty() {
        return this.mSelectedSystemProperty;
    }

    public void setSelectedSystem(CoordinateReferenceSystem crs) {
        this.mSelectedSystemProperty.set((Object)crs);
    }

    private void init() {
        String defaultSystems = "EPSG:3007\nEPSG:3008\nEPSG:3012\nEPSG:3009\nEPSG:3013\nEPSG:3010\nEPSG:3014\nEPSG:3011\nEPSG:3015\nEPSG:3016\nEPSG:3017\nEPSG:3018\nEPSG:3006\n";
        String[] items = StringUtils.split((String)this.mPreferences.get("crs.selected", defaultSystems), (String)"\n");
        HashSet<String> storedSystems = new HashSet<String>(Arrays.asList(items));
        String codes = SystemHelper.getResourceAsString(this.getClass(), "AuthoritiesCodes.txt");
        Comparator comparator = (o1, o2) -> o1.getName().toString().compareToIgnoreCase(o2.getName().toString());
        for (String ac : storedSystems) {
            try {
                this.mSelectedSystems.add((Object)CRS.decode((String)ac));
            }
            catch (FactoryException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
        Collections.sort(this.mSelectedSystems, comparator);
        new Thread(() -> {
            for (String ac : codes.lines().toList()) {
                try {
                    this.mAllSystems.add(CRS.decode((String)ac));
                }
                catch (FactoryException ex) {
                    LOGGER.log(Level.SEVERE, null, ex);
                }
            }
            Collections.sort(this.mAllSystems, comparator);
        }).start();
    }

    private void initListeners() {
        Lookup.getDefault().lookupResult(MCooTrans.class).addLookupListener(lookupEvent -> this.updateProviders());
    }

    private void updateProviders() {
        ArrayList lookupItems = new ArrayList(Lookup.getDefault().lookupAll(MCooTrans.class));
        ArrayList<GeoToolsCooTrans> items = new ArrayList<GeoToolsCooTrans>(lookupItems);
        for (CoordinateReferenceSystem crs : this.mSelectedSystems) {
            items.add(new GeoToolsCooTrans(CRS.toSRS((CoordinateReferenceSystem)crs)));
        }
        ((ObservableList)this.mItemsProperty.get()).setAll(items);
    }

    private static class Holder {
        private static final MCrsManager INSTANCE = new MCrsManager();

        private Holder() {
        }
    }
}

