/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.prefs.Preferences;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.openide.util.NbPreferences;

public class MDataSource {
    private static final Preferences sPreferences = NbPreferences.forModule(MDataSource.class);

    public static void addIfMissing(String key, File file) {
        String defaultContent = "";
        switch (key) {
            case "data_sources.wms.sources": {
                defaultContent = MDataSource.getDefaultSources();
                break;
            }
            case "data_sources.wms.styles": {
                defaultContent = MDataSource.getDefaultStyles();
            }
        }
        String content = sPreferences.get(key, defaultContent);
        String absolutePath = file.getAbsolutePath();
        if (!StringUtils.containsIgnoreCase((CharSequence)content, (CharSequence)absolutePath)) {
            boolean addRow = !content.isEmpty() && !StringUtils.endsWith((CharSequence)content, (CharSequence)"\n");
            String prefix = addRow ? "\n" : "";
            sPreferences.put(key, content + prefix + absolutePath + "\n");
        }
    }

    public static String getDefaultSources() {
        try {
            return IOUtils.toString((URI)new URI("https://mapton.org/files/data_sources_wms_sources_defaults"), (String)"utf-8") + "\n";
        }
        catch (IOException | URISyntaxException ex) {
            return "# Defaults not found\n";
        }
    }

    public static String getDefaultStyles() {
        try {
            return IOUtils.toString((URI)new URI("https://mapton.org/files/data_sources_wms_styles_defaults"), (String)"utf-8") + "\n";
        }
        catch (IOException | URISyntaxException ex) {
            return "# Defaults not found\n";
        }
    }

    public static Preferences getPreferences() {
        return sPreferences;
    }
}

