/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import org.apache.commons.lang3.Range;

public class MDecDegDMS {
    private static final Range<Integer> LAT_RANGE = Range.between((Comparable)Integer.valueOf(-90), (Comparable)Integer.valueOf(90));
    private static final Range<Integer> LON_RANGE = Range.between((Comparable)Integer.valueOf(-180), (Comparable)Integer.valueOf(180));
    private static final Range<Integer> MIN_RANGE = Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(59));
    private static final Range<Double> SEC_RANGE = Range.between((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(59.999999));
    private boolean mAbsolute;
    private double mDecDeg;
    private int mLatDeg;
    private int mLatMin;
    private double mLatSec;
    private int mLonDeg;
    private int mLonMin;
    private double mLonSec;

    public MDecDegDMS(double decdeg, boolean absolute) {
        this.mDecDeg = decdeg;
        this.mAbsolute = absolute;
    }

    public MDecDegDMS(double decdeg) {
        this(decdeg, false);
    }

    public MDecDegDMS(int latDeg, int latMin, double latSec, int lonDeg, int lonMin, double lonSec) {
        this.mLatDeg = latDeg;
        this.mLatMin = latMin;
        this.mLatSec = latSec;
        this.mLonDeg = lonDeg;
        this.mLonMin = lonMin;
        this.mLonSec = lonSec;
        if (!(LAT_RANGE.contains((Object)latDeg) && MIN_RANGE.contains((Object)latMin) && SEC_RANGE.contains((Object)latSec) && LON_RANGE.contains((Object)lonDeg) && MIN_RANGE.contains((Object)lonMin) && SEC_RANGE.contains((Object)lonSec))) {
            throw new IllegalArgumentException();
        }
    }

    public String format(String format, String pos, String neg) {
        Object[] objectArray = new Object[4];
        objectArray[0] = this.getDeg();
        objectArray[1] = this.getMin();
        objectArray[2] = this.getSec();
        objectArray[3] = this.mAbsolute ? (this.mDecDeg < 0.0 ? neg : pos) : pos;
        return format.formatted(objectArray);
    }

    public double getDecimalDegrees() {
        return this.mAbsolute ? Math.abs(this.mDecDeg) : this.mDecDeg;
    }

    public int getDeg() {
        return (int)this.getDecimalDegrees();
    }

    public double getLatitude() {
        double lat = (double)((float)Math.abs(this.mLatDeg) + (float)this.mLatMin / 60.0f) + this.mLatSec / 3600.0;
        return this.mLatDeg < 0 ? -1.0 * lat : lat;
    }

    public double getLongitude() {
        double lon = (double)((float)Math.abs(this.mLonDeg) + (float)this.mLonMin / 60.0f) + this.mLonSec / 3600.0;
        return this.mLonDeg < 0 ? -1.0 * lon : lon;
    }

    public int getMin() {
        return Math.abs((int)((this.getDecimalDegrees() - (double)this.getDeg()) * 60.0));
    }

    public double getSec() {
        return (Math.abs(this.getDecimalDegrees() - (double)this.getDeg()) - (double)this.getMin() / 60.0) * 3600.0;
    }
}

