/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javax.swing.JComponent;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.mapton.api.MEngineListener;
import org.mapton.api.MLatLon;
import org.mapton.api.MLatLonBox;
import org.mapton.api.MOptions;
import org.mapton.api.MStatusZoomMode;
import org.mapton.api.Mapton;
import org.openide.util.Lookup;

public abstract class MEngine {
    public static final String KEY_STATUS_COORDINATE = "Status.Coordinate";
    public static final String KEY_STATUS_PROGRESS = "Status.Progress";
    protected static final Logger LOGGER = Logger.getLogger(MEngine.class.getName());
    private static final TreeMap<String, MEngine> ENGINES = new TreeMap();
    private static final HashSet<MEngineListener> sEngineListeners = new HashSet();
    private Double mAltitude;
    private Double mElevation;
    private Callable<BufferedImage> mImageRenderer;
    private boolean mInitialized;
    private MLatLon mLatLonMouse;
    private Double mLatitude;
    private Double mLockedLatitude;
    private Double mLockedLongitude;
    private Double mLongitude;

    public static boolean addEngineListener(MEngineListener engineListener) {
        return sEngineListeners.add(engineListener);
    }

    public static MEngine byName(String name) {
        return ENGINES.getOrDefault(name, null);
    }

    public static void clearEngineListener(MEngineListener engineListener) {
        sEngineListeners.clear();
    }

    public static boolean removeEngineListener(MEngineListener engineListener) {
        return sEngineListeners.remove(engineListener);
    }

    private static void populateEngines() {
        ENGINES.clear();
        Lookup.getDefault().lookupAll(MEngine.class).forEach(engine -> ENGINES.put(engine.getName(), (MEngine)engine));
    }

    public abstract void create(Runnable var1);

    public void displayContextMenu(Point screenXY) {
        this.mLockedLatitude = this.mLatitude;
        this.mLockedLongitude = this.mLongitude;
        Runnable r = () -> {
            for (MEngineListener engineListener : sEngineListeners) {
                try {
                    engineListener.displayContextMenu(screenXY);
                }
                catch (Exception e) {
                    Mapton.getLog().e(this.getClass().getSimpleName(), e.getMessage());
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater(() -> r.run());
        }
    }

    public void fitToBounds(MLatLonBox latLonBox) {
        Mapton.getLog().i(this.getClass().getSimpleName(), "fitToBounds not implemented");
    }

    public void fitToBounds(Geometry geometry) {
        Mapton.getLog().i(this.getClass().getSimpleName(), "fitToBounds not implemented");
    }

    public void fitToBounds(ArrayList<Coordinate> coordinates) {
        Mapton.getLog().i(this.getClass().getSimpleName(), "fitToBounds not implemented");
    }

    public Double getAltitude() {
        return this.mAltitude;
    }

    public MLatLon getCenter() {
        Mapton.getLog().i(this.getClass().getSimpleName(), "getCenter not implemented");
        return new MLatLon(0.0, 0.0);
    }

    public Double getElevation() {
        return this.mElevation;
    }

    public Callable<BufferedImage> getImageRenderer() {
        return this.mImageRenderer;
    }

    public MLatLon getLatLon() {
        return new MLatLon(this.mLatitude, this.mLongitude);
    }

    public MLatLon getLatLonMouse() {
        return this.mLatLonMouse;
    }

    public Double getLatitude() {
        return this.mLatitude;
    }

    public double getLatitudeProj() {
        return this.options().getMapCooTrans().getLatitude(this.mLatitude, this.mLongitude);
    }

    public Node getLayerView() {
        Mapton.getLog().i(this.getClass().getSimpleName(), "getLayerView not implemented");
        return new Pane();
    }

    public MLatLon getLockedLatLon() {
        return new MLatLon(this.mLockedLatitude, this.mLockedLongitude);
    }

    public Double getLockedLatitude() {
        return this.mLockedLatitude;
    }

    public double getLockedLatitudeProj() {
        return this.options().getMapCooTrans().getLatitude(this.mLockedLatitude, this.mLockedLongitude);
    }

    public Double getLockedLongitude() {
        return this.mLockedLongitude;
    }

    public double getLockedLongitudeProj() {
        return this.options().getMapCooTrans().getLongitude(this.mLockedLatitude, this.mLockedLongitude);
    }

    public Double getLongitude() {
        return this.mLongitude;
    }

    public double getLongitudeProj() {
        return this.options().getMapCooTrans().getLongitude(this.mLatitude, this.mLongitude);
    }

    public abstract JComponent getMapComponent();

    public abstract Node getMapNode();

    public abstract String getName();

    public Node getRulerView() {
        Mapton.getLog().i(this.getClass().getSimpleName(), "getRulerView not implemented");
        return null;
    }

    public MStatusZoomMode getStatusZoomMode() {
        return MStatusZoomMode.ABSOLUTE;
    }

    public abstract Node getStyleView();

    public double getZoom() {
        Mapton.getLog().i(this.getClass().getSimpleName(), "getZoom not implemented");
        return 0.2;
    }

    public final void goHome() {
        this.panTo(this.options().getMapHome(), this.options().getMapHomeZoom());
    }

    public void hideContextMenu() {
        Runnable r = () -> {
            for (MEngineListener engineListener : sEngineListeners) {
                try {
                    engineListener.hideContextMenu();
                }
                catch (Exception e) {
                    Mapton.getLog().e(this.getClass().getSimpleName(), e.getMessage());
                }
            }
        };
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater(() -> r.run());
        }
    }

    public final void initialized() {
        this.mInitialized = true;
        this.panTo(this.options().getMapCenter(), this.options().getMapZoom());
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public boolean isSwing() {
        return true;
    }

    public void log(String message) {
        Mapton.getLog().v(this.getClass().getSimpleName(), message);
    }

    public void onActivate() {
    }

    public void onClosing() {
    }

    public void onDeactivate() {
    }

    public void onOpening() {
    }

    public void onStyleSwap() {
        Mapton.getLog().i(this.getClass().getSimpleName(), "style swap not implemented");
    }

    public void onWhatsHere(String s) {
        Mapton.getLog().i(this.getClass().getSimpleName(), "displayWhatsHere not implemented");
    }

    public void panTo(MLatLon latLon) {
        Mapton.getLog().i(this.getClass().getSimpleName(), "panTo not implemented");
    }

    public void panTo(MLatLon latLon, double zoom) {
        Mapton.getLog().i(this.getClass().getSimpleName(), "panTo(Zoom) not implemented");
    }

    public void refreshUI() {
    }

    public void setImageRenderer(Callable<BufferedImage> imageRenderer) {
        this.mImageRenderer = imageRenderer;
    }

    public void setLatitude(double latitude) {
        this.mLatitude = latitude;
    }

    public void setLockedLatitude(Double lockedLatitude) {
        this.mLockedLatitude = lockedLatitude;
    }

    public void setLockedLongitude(Double lockedLongitude) {
        this.mLockedLongitude = lockedLongitude;
    }

    public void setLongitude(double longitude) {
        this.mLongitude = longitude;
    }

    public final void setStatusMousePositionData(MLatLon latLonMouse, Double elevation, Double altitude) {
        this.mLatLonMouse = latLonMouse;
        if (latLonMouse != null) {
            this.mLatitude = latLonMouse.getLatitude();
            this.mLongitude = latLonMouse.getLongitude();
        } else {
            this.mLatitude = null;
            this.mLongitude = null;
        }
        this.mElevation = elevation;
        this.mAltitude = altitude;
        Mapton.getGlobalState().put(KEY_STATUS_COORDINATE, latLonMouse);
    }

    public void setStatusProgress(double progress) {
        Mapton.getGlobalState().put(KEY_STATUS_PROGRESS, progress);
    }

    public void swapStyle() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void zoomTo(double zoom) {
        this.panTo(this.getCenter(), zoom);
    }

    protected MOptions options() {
        return MOptions.getInstance();
    }

    static {
        Lookup.getDefault().lookupResult(MEngine.class).addLookupListener(lookupEvent -> MEngine.populateEngines());
        MEngine.populateEngines();
    }
}

