/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MFileWatcherListener;
import org.openide.util.Exceptions;

public class MFileWatcher {
    private final DigestUtils mDigestUtils = new DigestUtils("SHA-256");
    private final HashMap<File, String> mFileToDigest = new HashMap();
    private final HashMap<File, Boolean> mFileToBoolean = new HashMap();

    public void enable(File file) {
        this.mFileToBoolean.put(file, Boolean.TRUE);
    }

    public void disable(File file) {
        this.mFileToBoolean.put(file, Boolean.FALSE);
    }

    public static MFileWatcher getInstance() {
        return Holder.INSTANCE;
    }

    private MFileWatcher() {
    }

    public void addWatch(final File file, long interval, final MFileWatcherListener fileWatcherListener) {
        File directory = file.getParentFile();
        IOFileFilter directoryFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter((String)directory.getName())});
        IOFileFilter fileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), FileFilterUtils.nameFileFilter((String)file.getName())});
        IOFileFilter filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{directoryFilter, fileFilter});
        FileAlterationObserver observer = new FileAlterationObserver(directory, (FileFilter)filter);
        FileAlterationMonitor monitor = new FileAlterationMonitor(TimeUnit.SECONDS.toMillis(1L), new FileAlterationObserver[]{observer});
        FileAlterationListenerAdaptor listener = new FileAlterationListenerAdaptor(){
            private final File fileToMonitor;
            {
                this.fileToMonitor = file;
            }

            public void onFileChange(File file2) {
                if (file2.equals(this.fileToMonitor) && MFileWatcher.this.mFileToBoolean.getOrDefault(file2, Boolean.TRUE).booleanValue()) {
                    String oldValue = MFileWatcher.this.mFileToDigest.get(file2);
                    try {
                        String newValue = MFileWatcher.this.mDigestUtils.digestAsHex(file2);
                        if (!StringUtils.equals((CharSequence)newValue, (CharSequence)oldValue)) {
                            MFileWatcher.this.mFileToDigest.put(file2, newValue);
                            fileWatcherListener.onFileChange(file2);
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }

            public void onFileDelete(File file2) {
                if (file2.equals(this.fileToMonitor)) {
                    fileWatcherListener.onFileDelete(file2);
                }
            }
        };
        new Thread(() -> MFileWatcher.lambda$addWatch$0(observer, listener, monitor), "%s: %s".formatted(MFileWatcher.class.getName(), file.getName())).start();
    }

    private static /* synthetic */ void lambda$addWatch$0(FileAlterationObserver observer, 1 listener, FileAlterationMonitor monitor) {
        observer.addListener((FileAlterationListener)listener);
        try {
            monitor.start();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class Holder {
        private static final MFileWatcher INSTANCE = new MFileWatcher();

        private Holder() {
        }
    }
}

