/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import com.google.gson.annotations.SerializedName;

public class MLatLon {
    public static final double EARTH_RADIUS_METERS = 6378137.0;
    @SerializedName(value="latitude")
    private final double mLatitude;
    @SerializedName(value="longitude")
    private final double mLongitude;

    public MLatLon(double latitude, double longitude) {
        this.mLatitude = latitude;
        this.mLongitude = longitude;
    }

    public double distance(MLatLon anotherLatLon) {
        double dLat = (anotherLatLon.getLatitude() - this.getLatitude()) * Math.PI / 180.0;
        double dLon = (anotherLatLon.getLongitude() - this.getLongitude()) * Math.PI / 180.0;
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(this.getLatitude() * Math.PI / 180.0) * Math.cos(anotherLatLon.getLatitude() * Math.PI / 180.0) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double d = 6378137.0 * c;
        return d;
    }

    public double getBearing(MLatLon end) {
        if (this.equals(end)) {
            return 0.0;
        }
        double lat1 = this.latToRadians();
        double lon1 = this.longToRadians();
        double lat2 = end.latToRadians();
        double lon2 = end.longToRadians();
        double angle = -Math.atan2(Math.sin(lon1 - lon2) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2));
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        return Math.toDegrees(angle);
    }

    public MLatLon getDestinationPoint(double bearing, double distance) {
        double brng = Math.toRadians(bearing);
        double lat1 = this.latToRadians();
        double lon1 = this.longToRadians();
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(distance / 6378137.0) + Math.cos(lat1) * Math.sin(distance / 6378137.0) * Math.cos(brng));
        double lon2 = lon1 + Math.atan2(Math.sin(brng) * Math.sin(distance / 6378137.0) * Math.cos(lat1), Math.cos(distance / 6378137.0) - Math.sin(lat1) * Math.sin(lat2));
        return new MLatLon(Math.toDegrees(lat2), Math.toDegrees(lon2));
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public double latToRadians() {
        return Math.toRadians(this.getLatitude());
    }

    public double longToRadians() {
        return Math.toRadians(this.getLongitude());
    }

    public String toString() {
        return "lat: " + "%.8G".formatted(this.getLatitude()) + " lng: " + "%.8G".formatted(this.getLongitude());
    }
}

