/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.commons.io.FileUtils;
import org.mapton.api.MLocalGrid;
import org.mapton.api.MOptions;

public class MLocalGridManager {
    private final Gson mGson = new GsonBuilder().setVersion(1.0).serializeNulls().setPrettyPrinting().create();
    private final ObservableList<MLocalGrid> mItems = FXCollections.observableArrayList();
    private final MOptions mOptions = MOptions.getInstance();

    public static MLocalGridManager getInstance() {
        return Holder.INSTANCE;
    }

    private MLocalGridManager() {
    }

    public ObservableList<MLocalGrid> getItems() {
        return this.mItems;
    }

    public void gridExport(File file, ArrayList<MLocalGrid> selectedGrids) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)this.mGson.toJson(selectedGrids), (String)"utf-8");
    }

    public void gridImport(File file) throws IOException {
        String json = FileUtils.readFileToString((File)file, (String)"utf-8");
        ArrayList fileGrids = (ArrayList)this.mGson.fromJson(json, new TypeToken<ArrayList<MLocalGrid>>(){}.getType());
        Platform.runLater(() -> {
            this.mItems.addAll((Collection)fileGrids);
            FXCollections.sort(this.mItems, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        });
    }

    public ArrayList<MLocalGrid> loadItems() {
        return (ArrayList)this.mGson.fromJson(this.mOptions.get("local_grids", new String[0]), new TypeToken<ArrayList<MLocalGrid>>(){}.getType());
    }

    public void removeAll(MLocalGrid ... localGrids) {
        this.getItems().removeAll((Object[])localGrids);
    }

    public void save() {
        this.mOptions.put("local_grids", this.mGson.toJson(this.mItems));
    }

    public void sort() {
        FXCollections.sort(this.mItems, (o1, o2) -> o1.getName().compareTo(o2.getName()));
    }

    private static class Holder {
        private static final MLocalGridManager INSTANCE = new MLocalGridManager();

        private Holder() {
        }
    }
}

