/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.awt.geom.Path2D;
import java.util.HashMap;
import java.util.HashSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MLatLon;

public class MPolygonFilterManager {
    private final HashSet<Runnable> mListeners = new HashSet();
    private final HashMap<String, Path2D.Double> mNameToPolygon = new HashMap();
    private final ObservableMap<String, Path2D.Double> mObservableMap = FXCollections.observableMap(this.mNameToPolygon);

    public static MPolygonFilterManager getInstance() {
        return Holder.INSTANCE;
    }

    private MPolygonFilterManager() {
        this.mObservableMap.addListener(change -> this.mListeners.forEach(r -> r.run()));
    }

    public boolean addListener(Runnable r) {
        return this.mListeners.add(r);
    }

    public boolean contains(Double lat, Double lon) {
        return this.mNameToPolygon.values().stream().anyMatch(path -> path.contains(lon, lat));
    }

    public boolean contains(MLatLon latLon) {
        return this.contains(latLon.getLatitude(), latLon.getLongitude());
    }

    public ObservableMap<String, Path2D.Double> getObservableMap() {
        return this.mObservableMap;
    }

    public boolean hasItems() {
        return !this.mNameToPolygon.isEmpty();
    }

    public boolean isValidCoordinate(Double lat, Double lon, boolean usePolygonfilter) {
        boolean validCoordinate = !this.hasItems() || !usePolygonfilter || usePolygonfilter && this.contains(lat, lon);
        return validCoordinate;
    }

    public boolean isValidCoordinate(MLatLon latLon, boolean usePolygonfilter) {
        return this.isValidCoordinate(latLon.getLatitude(), latLon.getLongitude(), usePolygonfilter);
    }

    public Path2D.Double put(String key, String value) {
        return this.put(key, this.createPathFromString(value));
    }

    public Path2D.Double put(String key, Path2D.Double value) {
        if (value != null) {
            return (Path2D.Double)this.mObservableMap.put((Object)key, (Object)value);
        }
        this.mObservableMap.remove((Object)key);
        return null;
    }

    private Path2D.Double createPathFromString(String string) {
        try {
            Path2D.Double p = new Path2D.Double();
            boolean first = true;
            for (String line : StringUtils.split((String)string, (String)"\n")) {
                String[] elements = StringUtils.split((String)line, (String)" ");
                Double x = Double.valueOf(elements[0]);
                Double y = Double.valueOf(elements[1]);
                if (first) {
                    first = false;
                    p.moveTo(x, y);
                    continue;
                }
                p.lineTo(x, y);
            }
            p.closePath();
            return p;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class Holder {
        private static final MPolygonFilterManager INSTANCE = new MPolygonFilterManager();

        private Holder() {
        }
    }
}

