/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.util.ArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.commons.lang3.ObjectUtils;
import org.mapton.api.MLatLon;
import org.mapton.api.MLatLonBox;
import org.mapton.api.MPoi;
import org.mapton.api.Mapton;

public class MTemporaryPoiManager {
    private final ObjectProperty<ObservableList<MPoi>> mItemsProperty = new SimpleObjectProperty();

    public static void clear() {
        MTemporaryPoiManager.getInstance().getItems().clear();
    }

    public static MTemporaryPoiManager getInstance() {
        return Holder.INSTANCE;
    }

    private MTemporaryPoiManager() {
        this.mItemsProperty.setValue((Object)FXCollections.observableArrayList());
    }

    public void fitToBounds() {
        ArrayList<MLatLon> latLons = new ArrayList<MLatLon>();
        this.getItems().stream().filter(poi -> ObjectUtils.allNotNull((Object[])new Object[]{poi.getLatitude(), poi.getLongitude()})).forEach(poi -> latLons.add(new MLatLon(poi.getLatitude(), poi.getLongitude())));
        Mapton.getEngine().fitToBounds(new MLatLonBox(latLons));
    }

    public final ObservableList<MPoi> getItems() {
        return (ObservableList)this.mItemsProperty.get();
    }

    public void goTo(MPoi poi) {
        Mapton.getEngine().panTo(new MLatLon(poi.getLatitude(), poi.getLongitude()), poi.getZoom());
    }

    public final ObjectProperty<ObservableList<MPoi>> itemsProperty() {
        return this.mItemsProperty;
    }

    private static class Holder {
        private static final MTemporaryPoiManager INSTANCE = new MTemporaryPoiManager();

        private Holder() {
        }
    }
}

