/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.mapton.api.MAttribution;
import org.mapton.api.MWmsSource;
import org.mapton.api.MWmsStyle;

public abstract class MWmsGenerator {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected final Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().setVersion(1.0).setPrettyPrinting().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    protected final ArrayList<MWmsSource> mSources = new ArrayList();
    protected final ArrayList<MWmsStyle> mStyles = new ArrayList();
    protected final TreeMap<String, String> mCategoriesEarth = new TreeMap();
    protected final TreeMap<String, String> mCategoriesSwe = new TreeMap();

    public MWmsGenerator() {
        this.mCategoriesEarth.put("", "Earth");
        this.mCategoriesEarth.put("sv", "Jorden");
        this.mCategoriesSwe.put("", "Sweden");
        this.mCategoriesSwe.put("sv", "Sverige");
    }

    public MWmsSource createSource(String name, String url, TreeMap<String, String> layers, TreeMap<String, MAttribution> attributions, boolean enabled) {
        MWmsSource source = new MWmsSource();
        source.setName(name);
        source.setEnabled(enabled);
        source.setUrl(url);
        source.setLayers(layers);
        source.setAttributions(attributions);
        return source;
    }

    public MWmsStyle createStyle(TreeMap<String, String> categories, TreeMap<String, String> names, TreeMap<String, String> descriptions, String supplier, boolean enabled, String id, String ... layers) {
        MWmsStyle style = new MWmsStyle();
        style.setCategories(categories);
        style.setNames(names);
        style.setEnabled(enabled);
        style.setSupplier(supplier);
        style.setDescriptions(descriptions);
        style.setId(id);
        style.setLayers(new ArrayList<String>(Arrays.asList(layers)));
        return style;
    }

    public String getSourceJson() {
        return this.gson.toJson(this.mSources);
    }

    public String getStyleJson() {
        return this.gson.toJson(this.mStyles);
    }
}

