/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api.db;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSchema;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.mapton.api.db.Db;
import org.mapton.api.db.PlaceHolderController;
import org.openide.util.Exceptions;

public abstract class DbBaseManager {
    protected static final String SQL_BIGINT = "BIGINT";
    protected static final String SQL_BIGINT_NOT_NULL = "BIGINT not null";
    protected static final String SQL_BOOLEAN = "BOOLEAN";
    protected static final String SQL_DATE = "DATE";
    protected static final String SQL_DOUBLE = "DOUBLE";
    protected static final String SQL_IDENTITY = "IDENTITY";
    protected static final String SQL_INTEGER = "INTEGER";
    protected static final String SQL_TIMESTAMP = "TIMESTAMP";
    protected static final String SQL_VARCHAR = "VARCHAR";
    protected static final int TYPE_LENGTH_1M = 0x100000;
    protected final Db mDb;
    protected DbColumn mId;
    protected PlaceHolderController mInsertPlaceHolders = new PlaceHolderController();
    protected PreparedStatement mInsertPreparedStatement;
    protected PlaceHolderController mSelectPlaceHolders = new PlaceHolderController();
    protected PreparedStatement mSelectPreparedStatement;
    protected DbTable mTable;
    protected PlaceHolderController mUpdatePlaceHolders = new PlaceHolderController();
    protected PreparedStatement mUpdatePreparedStatement;

    public DbBaseManager() {
        this.mDb = Db.getInstance();
    }

    public abstract void create();

    public boolean exists(DbColumn exceptForColumn, Object exceptForValue, HashMap<DbColumn, Object> map) {
        boolean bl;
        block10: {
            PlaceHolderController placeHolders = new PlaceHolderController();
            SelectQuery selectQuery = (SelectQuery)new SelectQuery().addFromTable((Table)this.mTable).addAllColumns().validate();
            if (exceptForValue != null) {
                selectQuery.addCondition((Condition)BinaryCondition.notEqualTo((Object)exceptForColumn, (Object)exceptForValue));
            }
            map.keySet().forEach(column -> {
                placeHolders.add(new Column[]{column});
                selectQuery.addCondition((Condition)BinaryCondition.equalTo((Object)column, (Object)placeHolders.get(column)));
            });
            selectQuery.validate();
            String sql = selectQuery.toString();
            PreparedStatement preparedStatement = this.mDb.getAutoCommitConnection().prepareStatement(sql, 2);
            try {
                for (Map.Entry<DbColumn, Object> entry : map.entrySet()) {
                    placeHolders.get(entry.getKey()).setString((String)entry.getValue(), preparedStatement);
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                bl = resultSet.first();
                if (preparedStatement == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return false;
                }
            }
            preparedStatement.close();
        }
        return bl;
    }

    public DbColumn getId() {
        return this.mId;
    }

    public String getIndexName(DbColumn[] dbColumns, String suffix) {
        StringBuilder builder = new StringBuilder(this.mTable.getName()).append("_");
        if (dbColumns != null) {
            for (DbColumn dbColumn : dbColumns) {
                builder.append(dbColumn.getName()).append("_");
            }
        }
        if (builder.lastIndexOf("_") != builder.length() - 1) {
            builder.append("_");
        }
        builder.append(suffix);
        return builder.toString();
    }

    public DbSchema getSchema() {
        return this.mDb.getSpec().getDefaultSchema();
    }

    public DbTable getTable() {
        return this.mTable;
    }

    protected void addNotNullConstraints(DbColumn ... columns) {
        for (DbColumn column : columns) {
            column.addConstraint(new DbConstraint(column, "nnc_" + column.getName(), Constraint.Type.NOT_NULL));
        }
    }

    protected Boolean getBoolean(ResultSet rs, DbColumn column) throws SQLException {
        return this.getBoolean(rs, column.getName());
    }

    protected Boolean getBoolean(ResultSet rs, String column) throws SQLException {
        return rs.getBoolean(column);
    }

    protected Double getDouble(ResultSet rs, DbColumn column) throws SQLException {
        return this.getDouble(rs, column.getName());
    }

    protected Double getDouble(ResultSet rs, String columnName) throws SQLException {
        return rs.getObject(columnName, Double.class);
    }

    protected String getFilterPattern(String filter) {
        filter = filter.replaceAll("\\*", "%");
        if ((filter = filter.replaceAll("\\?", "_")).length() == 0) {
            filter = "%";
        }
        if (!filter.contains("%")) {
            filter = "%%%s%%".formatted(filter);
        }
        return filter;
    }

    protected Integer getInteger(ResultSet rs, DbColumn column) throws SQLException {
        return this.getInteger(rs, column.getName());
    }

    protected Integer getInteger(ResultSet rs, String columnName) throws SQLException {
        return rs.getObject(columnName, Integer.class);
    }

    protected Long getLong(ResultSet rs, DbColumn column) throws SQLException {
        return this.getLong(rs, column.getName());
    }

    protected Long getLong(ResultSet rs, String columnName) throws SQLException {
        return rs.getObject(columnName, Long.class);
    }

    protected String getString(ResultSet rs, DbColumn column) throws SQLException {
        return this.getString(rs, column.getName());
    }

    protected String getString(ResultSet rs, String columnName) throws SQLException {
        return rs.getString(columnName);
    }

    protected Timestamp getTimestamp(ResultSet rs, DbColumn column) throws SQLException {
        return rs.getTimestamp(column.getName());
    }

    public class Columns {
        public DbColumn getId() {
            return DbBaseManager.this.mId;
        }
    }
}

