/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api.ext.worldwind;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.mapton.api.ext.worldwind.AVList;
import org.mapton.api.ext.worldwind.Logging;
import org.mapton.api.ext.worldwind.WWRuntimeException;

public class AVListImpl
implements AVList {
    private static final String PROPERTY_CHANGE_SUPPORT = "avlist.PropertyChangeSupport";
    private Map<String, Object> avList;

    public static Boolean getBooleanValue(AVList avList, String key, Boolean defaultValue) {
        Boolean v = AVListImpl.getBooleanValue(avList, key);
        return v != null ? v : defaultValue;
    }

    public static Boolean getBooleanValue(AVList avList, String key) {
        Object o = avList.getValue(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        String v = AVListImpl.getStringValue(avList, key);
        if (v == null) {
            return null;
        }
        try {
            return Boolean.parseBoolean(v);
        }
        catch (NumberFormatException e) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", v);
            return null;
        }
    }

    public static Double getDoubleValue(AVList avList, String key, Double defaultValue) {
        Double v = AVListImpl.getDoubleValue(avList, key);
        return v != null ? v : defaultValue;
    }

    public static Double getDoubleValue(AVList avList, String key) {
        Object o = avList.getValue(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        String v = AVListImpl.getStringValue(avList, key);
        if (v == null) {
            return null;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException e) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", v);
            return null;
        }
    }

    public static Integer getIntegerValue(AVList avList, String key, Integer defaultValue) {
        Integer v = AVListImpl.getIntegerValue(avList, key);
        return v != null ? v : defaultValue;
    }

    public static Integer getIntegerValue(AVList avList, String key) {
        Object o = avList.getValue(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        String v = AVListImpl.getStringValue(avList, key);
        if (v == null) {
            return null;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", v);
            return null;
        }
    }

    public static Long getLongValue(AVList avList, String key, Long defaultValue) {
        Long v = AVListImpl.getLongValue(avList, key);
        return v != null ? v : defaultValue;
    }

    public static Long getLongValue(AVList avList, String key) {
        Object o = avList.getValue(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        String v = AVListImpl.getStringValue(avList, key);
        if (v == null) {
            return null;
        }
        try {
            return Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            Logging.logger().log(Level.SEVERE, "Configuration.ConversionError", v);
            return null;
        }
    }

    public static String getStringValue(AVList avList, String key, String defaultValue) {
        String v = AVListImpl.getStringValue(avList, key);
        return v != null ? v : defaultValue;
    }

    public static String getStringValue(AVList avList, String key) {
        try {
            return avList.getStringValue(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public AVListImpl() {
    }

    public AVListImpl(Object sourceBean) {
        if (sourceBean != null) {
            this.setValue(PROPERTY_CHANGE_SUPPORT, new PropertyChangeSupport(sourceBean));
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (propertyName == null) {
            String msg = Logging.getMessage("nullValue.PropertyNameIsNull");
            Logging.logger().severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (listener == null) {
            String msg = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.getChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            String msg = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.getChangeSupport().addPropertyChangeListener(listener);
    }

    @Override
    public synchronized AVList clearList() {
        if (this.hasAvList()) {
            this.avList.clear();
        }
        return this;
    }

    @Override
    public synchronized AVList copy() {
        AVListImpl clone = new AVListImpl();
        if (this.avList != null) {
            clone.createAvList();
            clone.avList.putAll(this.avList);
        }
        return clone;
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            String msg = Logging.getMessage("nullValue.PropertyChangeEventIsNull");
            Logging.logger().severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.getChangeSupport().firePropertyChange(propertyChangeEvent);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            String msg = Logging.getMessage("nullValue.PropertyNameIsNull");
            Logging.logger().severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.getChangeSupport().firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public synchronized Set<Map.Entry<String, Object>> getEntries() {
        return this.hasAvList() ? this.avList.entrySet() : this.createAvList().entrySet();
    }

    @Override
    public synchronized String getStringValue(String key) {
        if (key == null) {
            String msg = Logging.getMessage("nullValue.AttributeKeyIsNull");
            Logging.logger().severe(msg);
            throw new IllegalStateException(msg);
        }
        try {
            Object value = this.getValue(key);
            return value != null ? value.toString() : null;
        }
        catch (ClassCastException e) {
            String msg = Logging.getMessage("AVAAccessibleImpl.AttributeValueForKeyIsNotAString", key);
            Logging.logger().severe(msg);
            throw new WWRuntimeException(msg, e);
        }
    }

    @Override
    public synchronized Object getValue(String key) {
        if (key == null) {
            String message = Logging.getMessage("nullValue.AttributeKeyIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        if (this.hasAvList()) {
            return this.avList.get(key);
        }
        return null;
    }

    @Override
    public synchronized Collection<Object> getValues() {
        return this.hasAvList() ? this.avList.values() : this.createAvList().values();
    }

    @Override
    public synchronized boolean hasKey(String key) {
        if (key == null) {
            String message = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        return this.hasAvList() && this.avList.containsKey(key);
    }

    @Override
    public synchronized Object removeKey(String key) {
        if (key == null) {
            String message = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        return this.hasKey(key) ? this.avList.remove(key) : null;
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (propertyName == null) {
            String msg = Logging.getMessage("nullValue.PropertyNameIsNull");
            Logging.logger().severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (listener == null) {
            String msg = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.getChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            String msg = Logging.getMessage("nullValue.ListenerIsNull");
            Logging.logger().severe(msg);
            throw new IllegalArgumentException(msg);
        }
        this.getChangeSupport().removePropertyChangeListener(listener);
    }

    @Override
    public synchronized Object setValue(String key, Object value) {
        if (key == null) {
            String message = Logging.getMessage("nullValue.AttributeKeyIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        return this.avList(true).put(key, value);
    }

    @Override
    public synchronized AVList setValues(AVList list) {
        if (list == null) {
            String message = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(message);
            throw new IllegalArgumentException(message);
        }
        Set<Map.Entry<String, Object>> entries = list.getEntries();
        for (Map.Entry<String, Object> entry : entries) {
            this.setValue(entry.getKey(), entry.getValue());
        }
        return this;
    }

    protected synchronized PropertyChangeSupport getChangeSupport() {
        Object pcs = this.getValue(PROPERTY_CHANGE_SUPPORT);
        if (pcs == null || !(pcs instanceof PropertyChangeSupport)) {
            pcs = new PropertyChangeSupport(this);
            this.setValue(PROPERTY_CHANGE_SUPPORT, pcs);
        }
        return (PropertyChangeSupport)pcs;
    }

    private Map<String, Object> avList(boolean createIfNone) {
        if (createIfNone && !this.hasAvList()) {
            this.createAvList();
        }
        return this.avList;
    }

    private Map<String, Object> createAvList() {
        if (!this.hasAvList()) {
            this.avList = new HashMap<String, Object>(1);
        }
        return this.avList;
    }

    private boolean hasAvList() {
        return this.avList != null;
    }
}

