/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api.ext.worldwind;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Logging {
    protected static final String MESSAGE_BUNDLE_NAME = Logging.class.getPackage().getName() + ".MessageStrings";
    protected static final int MAX_MESSAGE_REPEAT = 10;

    private Logging() {
    }

    public static Logger logger() {
        try {
            String loggerName = "AVList";
            return Logging.logger(loggerName);
        }
        catch (Exception e) {
            return Logging.logger("AVList");
        }
    }

    public static Logger logger(String loggerName) {
        return Logger.getLogger(loggerName != null ? loggerName : "", MESSAGE_BUNDLE_NAME);
    }

    public static String getMessage(String property) {
        try {
            return (String)ResourceBundle.getBundle(MESSAGE_BUNDLE_NAME, Locale.getDefault()).getObject(property);
        }
        catch (Exception e) {
            String message = "Exception looking up message from bundle " + MESSAGE_BUNDLE_NAME;
            Logging.logger().log(Level.SEVERE, message, e);
            return message;
        }
    }

    public static String getMessage(String property, String arg) {
        return arg != null ? Logging.getMessage(property, new Object[]{arg}) : Logging.getMessage(property);
    }

    public static String getMessage(String property, Object ... args) {
        Object message;
        try {
            message = (String)ResourceBundle.getBundle(MESSAGE_BUNDLE_NAME, Locale.getDefault()).getObject(property);
        }
        catch (Exception e) {
            String message2 = "Exception looking up message from bundle " + MESSAGE_BUNDLE_NAME;
            Logging.logger().log(Level.SEVERE, message2, e);
            return message2;
        }
        try {
            return args == null ? message : MessageFormat.format((String)message, args);
        }
        catch (IllegalArgumentException e) {
            message = "Message arguments do not match format string: " + property;
            Logging.logger().log(Level.SEVERE, (String)message, e);
            return message;
        }
    }

    public static int getMaxMessageRepeatCount() {
        return 10;
    }
}

