/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api.report;

import java.util.Comparator;
import java.util.Locale;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.textfield.TextFields;
import org.mapton.api.Mapton;
import org.mapton.api.report.MSplitNavSettings;
import org.mapton.api.report.MSplitNavType;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.StringHelper;
import se.trixon.almond.util.fx.FxHelper;

public class MSplitNavPane<T extends MSplitNavType>
extends BorderPane {
    private final Class<? extends MSplitNavType> mClass;
    private BorderPane mDetailBorderPane;
    private VBox mDetailTopPane;
    private TextField mFilterTextField;
    private BorderPane mMasterBorderPane;
    private final TreeMap<String, TreeItem<T>> mParents = new TreeMap();
    private Label mPlaceholderLabel;
    private final Preferences mPreferences;
    private Label mTitleLabel;
    private ToolBar mToolBar;
    private TreeView<T> mTreeView;
    private final String mTypeName;

    public MSplitNavPane(Class<T> clazz, String typeName) {
        this.mClass = clazz;
        this.mTypeName = typeName;
        this.mPreferences = NbPreferences.forModule(this.mClass).node("expanded_state_" + this.mClass.getName());
        this.createUI();
    }

    private void createUI() {
        this.mPlaceholderLabel = new Label();
        this.mTreeView = new TreeView();
        this.mTreeView.setShowRoot(false);
        this.mTreeView.getSelectionModel().getSelectedItems().addListener(c -> {
            if (this.mTreeView.getSelectionModel().isEmpty()) {
                this.mDetailBorderPane.setTop(null);
                this.mDetailBorderPane.setCenter((Node)this.mPlaceholderLabel);
            } else {
                Platform.runLater(() -> this.load((MSplitNavType)((TreeItem)this.mTreeView.getSelectionModel().getSelectedItem()).getValue()));
            }
        });
        this.mFilterTextField = TextFields.createClearableTextField();
        this.mFilterTextField.setPromptText("%s %s".formatted(Dict.SEARCH.toString(), this.mTypeName.toLowerCase(Locale.getDefault())));
        this.mFilterTextField.textProperty().addListener((observable, oldValue, newValue) -> this.populate());
        this.mMasterBorderPane = new BorderPane(this.mTreeView);
        this.mMasterBorderPane.setPrefWidth((double)FxHelper.getUIScaled(300));
        this.mMasterBorderPane.setTop((Node)this.mFilterTextField);
        this.mDetailTopPane = new VBox();
        this.mTitleLabel = new Label();
        this.mTitleLabel.setPrefHeight((double)Mapton.getIconSizeToolBarInt() * 1.3);
        this.mTitleLabel.setStyle("-fx-font-size: %dpx;".formatted((int)(FxHelper.getScaledFontSize() * 1.5)));
        this.mTitleLabel.prefWidthProperty().bind((ObservableValue)this.mDetailTopPane.widthProperty());
        this.mTitleLabel.setAlignment(Pos.CENTER);
        this.mTitleLabel.setTextFill((Paint)Mapton.getThemeForegroundColor());
        this.mToolBar = new ToolBar();
        FxHelper.slimToolBar(this.mToolBar);
        this.mDetailBorderPane = new BorderPane((Node)this.mPlaceholderLabel);
        this.setLeft((Node)this.mMasterBorderPane);
        this.setCenter((Node)this.mDetailBorderPane);
        Lookup.getDefault().lookupResult(this.mClass).addLookupListener(lookupEvent -> this.populate());
        this.populate();
    }

    private TreeItem<T> getParent(TreeItem<T> parent, String category) {
        String[] categorySegments = StringUtils.split((String)category, (String)"/");
        StringBuilder sb = new StringBuilder();
        for (final String segment : categorySegments) {
            sb.append(segment);
            final String path = sb.toString();
            if (this.mParents.containsKey(path)) {
                parent = this.mParents.get(path);
            } else {
                MSplitNavType type = new MSplitNavType(){

                    @Override
                    public String getName() {
                        return segment;
                    }

                    @Override
                    public Node getNode() {
                        return null;
                    }

                    @Override
                    public String getParent() {
                        return path;
                    }

                    @Override
                    public MSplitNavSettings getSplitNavSettings() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    @Override
                    public void setName(String name) {
                    }

                    @Override
                    public void setParent(String parent) {
                    }

                    public String toString() {
                        return this.getName();
                    }
                };
                String key = sb.toString();
                if (this.mParents.containsKey(key)) {
                    parent = this.mParents.get(key);
                } else {
                    this.mParents.put(key, new TreeItem((Object)type));
                    ObservableList observableList = parent.getChildren();
                    parent = this.mParents.get(key);
                    observableList.add(parent);
                }
            }
            sb.append("/");
        }
        return parent;
    }

    private void load(T selectedType) {
        Node node = selectedType.getNode();
        if (node != null) {
            this.mDetailBorderPane.setTop((Node)this.mDetailTopPane);
            this.mDetailBorderPane.setCenter(node);
            this.loadSettings(selectedType);
            selectedType.onSelect();
        } else {
            this.mDetailBorderPane.setTop(null);
            this.mDetailBorderPane.setCenter(null);
        }
    }

    private void loadSettings(T item) {
        this.setTitle(item);
        MSplitNavSettings settings = item.getSplitNavSettings();
        Color color = settings.getTitleColor();
        if (color != null) {
            Background background = FxHelper.createBackground(color);
            this.mDetailTopPane.setBackground(background);
            this.mToolBar.setStyle("-fx-background-color: #%s;".formatted(FxHelper.colorToHexRGBA(color)));
        }
        ObservableList children = this.mDetailTopPane.getChildren();
        children.clear();
        if (settings.getTitleMode() != MSplitNavSettings.TitleMode.NONE) {
            children.add((Object)this.mTitleLabel);
        }
        this.mToolBar.getItems().clear();
        if (!settings.getToolBarItems().isEmpty()) {
            children.add((Object)this.mToolBar);
            this.mToolBar.getItems().setAll(settings.getToolBarItems());
        }
    }

    private synchronized void populate() {
        this.mParents.clear();
        MSplitNavType rootType = new MSplitNavType(){

            @Override
            public String getName() {
                return "";
            }

            @Override
            public Node getNode() {
                return null;
            }

            @Override
            public String getParent() {
                return "";
            }

            @Override
            public MSplitNavSettings getSplitNavSettings() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void setName(String name) {
            }

            @Override
            public void setParent(String parent) {
            }
        };
        TreeItem root = new TreeItem((Object)rootType);
        String filter = this.mFilterTextField.getText();
        Lookup.getDefault().lookupAll(this.mClass).forEach(type -> {
            boolean validFilter;
            boolean bl = validFilter = StringHelper.matchesSimpleGlob(type.getParent(), filter, true, true) || StringHelper.matchesSimpleGlob(type.getName(), filter, true, true);
            if (validFilter) {
                TreeItem treeItem = new TreeItem(type);
                String category = type.getParent();
                TreeItem<T> parent = !this.mParents.containsKey(category) ? this.mParents.put(category, this.getParent(root, category)) : this.mParents.get(category);
                parent.getChildren().add((Object)treeItem);
            }
        });
        this.postPopulate(root);
        FxHelper.runLater(() -> this.mTreeView.setRoot(root));
    }

    private void postPopulate(TreeItem<T> treeItem) {
        MSplitNavType value = (MSplitNavType)treeItem.getValue();
        String path = "%s/%s".formatted(value.getParent(), value.getName());
        treeItem.setExpanded(this.mPreferences.getBoolean(path, false));
        treeItem.expandedProperty().addListener((observable, oldValue, newValue) -> this.mPreferences.putBoolean(path, (boolean)newValue));
        Comparator c1 = (o1, o2) -> Boolean.compare(o1.getChildren().isEmpty(), o2.getChildren().isEmpty());
        Comparator c2 = (o1, o2) -> ((MSplitNavType)o1.getValue()).getName().compareTo(((MSplitNavType)o2.getValue()).getName());
        treeItem.getChildren().sort(c1.thenComparing(c2));
        for (TreeItem childTreeItem : treeItem.getChildren()) {
            this.postPopulate(childTreeItem);
        }
    }

    private void setTitle(T item) {
        MSplitNavSettings settings = item.getSplitNavSettings();
        Object titlePrefix = switch (settings.getTitleMode()) {
            case MSplitNavSettings.TitleMode.FULL_PATH -> item.getParent();
            case MSplitNavSettings.TitleMode.NAME_WITH_PARENT -> {
                if (StringUtils.contains((CharSequence)item.getParent(), (CharSequence)"/")) {
                    yield StringUtils.substringAfterLast((String)item.getParent(), (String)"/");
                }
                yield item.getParent();
            }
            default -> "";
        };
        if (((String)titlePrefix).length() > 0) {
            titlePrefix = (String)titlePrefix + "/";
        }
        if (settings.getTitle() == null) {
            this.mTitleLabel.setText((String)titlePrefix + item.getName());
        } else {
            this.mTitleLabel.setText((String)titlePrefix + settings.getTitle());
        }
    }
}

