/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api.report;

import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.HtmlTag;
import java.util.Comparator;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.web.WebView;
import org.mapton.api.Mapton;
import org.mapton.api.report.MReport;
import org.mapton.api.report.MSubReport;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;

public abstract class MSubReports
extends MReport {
    private BorderPane mBorderPane;
    private final Comparator<MSubReport> mComparator;
    private ListView<MSubReport> mListView;
    private WebView mWebView;

    public MSubReports() {
        this.setParent("- %s -".formatted(Dict.SYSTEM.toString()));
        this.mComparator = Comparator.comparing(MSubReport::getGroup).thenComparing(Comparator.comparing(MSubReport::getName));
    }

    public Comparator<MSubReport> getComparator() {
        return this.mComparator;
    }

    public ListView<MSubReport> getListView() {
        return this.mListView;
    }

    @Override
    public String getName() {
        return Dict.SYSTEM.toString();
    }

    @Override
    public Node getNode() {
        if (this.mBorderPane == null) {
            this.createUI();
        }
        return this.mBody;
    }

    public abstract void subInit();

    private void createUI() {
        this.mWebView = new WebView();
        Mapton.applyHtmlCss(this.mWebView, "report.css");
        this.mListView = new ListView();
        this.mListView.setPrefWidth((double)FxHelper.getUIScaled(250));
        this.mBorderPane = new BorderPane((Node)this.mWebView);
        this.mBorderPane.setLeft(this.mListView);
        this.mNotificationPane.setContent((Node)this.mBorderPane);
        this.mListView.setCellFactory(param -> new SubReportListCell());
        this.mListView.getSelectionModel().getSelectedItems().addListener(c -> this.loadReport());
        this.subInit();
    }

    private void loadReport() {
        MSubReport systemReport = (MSubReport)this.mListView.getSelectionModel().getSelectedItem();
        if (systemReport == null) {
            this.mWebView.getEngine().loadContent("");
        } else {
            this.mMaskerPane.setVisible(true);
            this.mWebView.getEngine().loadContent("");
            new Thread(() -> {
                HtmlTag html = TagCreator.html((DomContent[])new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.title((String)systemReport.getName())}), TagCreator.body((DomContent[])new DomContent[]{TagCreator.h1((String)systemReport.getName()), TagCreator.hr(), systemReport.getContent()})});
                Platform.runLater(() -> this.mWebView.getEngine().loadContent(html.render()));
                this.mMaskerPane.setVisible(false);
            }, this.getClass().getCanonicalName()).start();
        }
    }

    class SubReportListCell
    extends ListCell<MSubReport> {
        private final BorderPane mBorderPane = new BorderPane();
        private final Font mDefaultFont = Font.getDefault();
        private final Label mGroupLabel = new Label();
        private final Label mNameLabel = new Label();

        public SubReportListCell() {
            this.createUI();
        }

        protected void updateItem(MSubReport report, boolean empty) {
            super.updateItem((Object)report, empty);
            if (report == null || empty) {
                this.clearContent();
            } else {
                this.addContent(report);
            }
        }

        private void addContent(MSubReport report) {
            this.setText(null);
            this.mNameLabel.setText(report.getName());
            this.mGroupLabel.setText(report.getGroup());
            this.setGraphic((Node)this.mBorderPane);
        }

        private void clearContent() {
            this.setText(null);
            this.setGraphic(null);
        }

        private void createUI() {
            String fontFamily = this.mDefaultFont.getFamily();
            double fontSize = FxHelper.getScaledFontSize();
            this.mGroupLabel.setFont(Font.font((String)fontFamily, (FontWeight)FontWeight.NORMAL, (double)(fontSize * 0.8)));
            this.mNameLabel.setFont(Font.font((String)fontFamily, (FontWeight)FontWeight.BOLD, (double)(fontSize * 1.0)));
            VBox mainBox = new VBox(new Node[]{this.mGroupLabel, this.mNameLabel});
            mainBox.setAlignment(Pos.CENTER_LEFT);
            this.mBorderPane.setCenter((Node)mainBox);
            BorderPane.setMargin((Node)mainBox, (Insets)new Insets(8.0));
        }
    }
}

