/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api.ui;

import java.io.File;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.text.Font;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MDataSource;
import se.trixon.almond.util.fx.FxHelper;

public class DataSourceTab
extends Tab {
    private String mDefaults;
    private final String[] mDropExts;
    private final String mKey;
    private TextArea mTextArea;

    public DataSourceTab(String text, String key, String[] dropExts) {
        super(text);
        this.mKey = key;
        this.mDropExts = dropExts;
        this.init();
        this.initListeners();
    }

    public void load(String defaults) {
        this.mDefaults = defaults;
        this.mTextArea.setText(MDataSource.getPreferences().get(this.mKey, defaults));
    }

    public void restoreDefaults() {
        this.mTextArea.setText(this.mDefaults);
    }

    public void save() {
        MDataSource.getPreferences().put(this.mKey, this.mTextArea.getText());
    }

    private void append(File file) {
        this.mTextArea.appendText(file.getAbsolutePath() + "\n");
    }

    private void init() {
        this.mTextArea = new TextArea();
        this.mTextArea.setFont(Font.font((String)"monospaced", (double)(FxHelper.getScaledFontSize() * 1.3)));
        this.setContent((Node)this.mTextArea);
    }

    private void initListeners() {
        this.mTextArea.setOnDragOver(dragEvent -> {
            Dragboard dragBoard = dragEvent.getDragboard();
            if (dragBoard.hasFiles()) {
                dragEvent.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        });
        this.mTextArea.setOnDragDropped(dragEvent -> {
            for (File file : dragEvent.getDragboard().getFiles()) {
                if (this.mDropExts == null) {
                    this.append(file);
                    continue;
                }
                if (!StringUtils.equalsAnyIgnoreCase((CharSequence)FilenameUtils.getExtension((String)file.getName()), (CharSequence[])this.mDropExts)) continue;
                this.append(file);
            }
        });
    }
}

