/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api.ui;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.mapton.api.MDict;
import org.mapton.api.MPolygonFilterManager;
import org.mapton.api.Mapton;
import org.mapton.api.ui.MPopOver;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.DelayedResetRunner;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

public abstract class MFilterPopOver
extends MPopOver {
    private final Button allButton = new Button(Dict.SHOW_ALL.toString());
    private final Button clearButton = new Button(Dict.CLEAR.toString());
    private final VBox mBox;
    private final HBox mButtonBox;
    private final DelayedResetRunner mDelayedResetRunner;
    private final CheckBox mPolygonFilterCheckBox = new CheckBox(MDict.USE_GEO_FILTER.toString());
    private final MPolygonFilterManager mPolygonFilterManager = MPolygonFilterManager.getInstance();

    public MFilterPopOver() {
        String title = Dict.FILTER.toString();
        this.setTitle(title);
        this.getAction().setText(title);
        this.getAction().setGraphic((Node)MaterialIcon._Content.FILTER_LIST.getImageView(Mapton.getIconSizeToolBarInt()));
        this.allButton.setOnAction(event -> this.reset());
        this.clearButton.setOnAction(event -> this.clear());
        this.allButton.setPrefWidth((double)WIDTH);
        this.clearButton.setPrefWidth((double)WIDTH);
        this.mButtonBox = new HBox((double)GAP, new Node[]{this.allButton, this.clearButton});
        this.mButtonBox.setAlignment(Pos.CENTER);
        this.mBox = new VBox((double)FxHelper.getUIScaled(8), new Node[]{this.mButtonBox, this.mPolygonFilterCheckBox});
        this.mDelayedResetRunner = new DelayedResetRunner(500, () -> this.onPolygonFilterChange());
        this.mPolygonFilterManager.addListener(() -> this.mDelayedResetRunner.reset());
        this.mPolygonFilterCheckBox.selectedProperty().addListener((observable, oldValue, newValue) -> this.mDelayedResetRunner.reset());
    }

    public abstract void clear();

    public Node getButtonBox() {
        return this.mBox;
    }

    public CheckBox getPolygonFilterCheckBox() {
        return this.mPolygonFilterCheckBox;
    }

    public boolean isPolygonFilters() {
        return this.mPolygonFilterCheckBox.isSelected();
    }

    public abstract void onPolygonFilterChange();

    public abstract void reset();
}

