/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.jdktools;

import eu.hansolo.jdktools.Api;
import eu.hansolo.jdktools.util.OutputFormat;
import java.util.Arrays;
import java.util.List;

public enum Verification implements Api
{
    YES("yes", "yes"),
    NO("no", "no"),
    UNKNOWN("unknown", "unknown"),
    NONE("-", ""),
    NOT_FOUND("", "");

    private final String uiString;
    private final String apiString;

    private Verification(String uiString, String apiString) {
        this.uiString = uiString;
        this.apiString = apiString;
    }

    @Override
    public String getUiString() {
        return this.uiString;
    }

    @Override
    public String getApiString() {
        return this.apiString;
    }

    @Override
    public Verification getDefault() {
        return UNKNOWN;
    }

    @Override
    public Verification getNotFound() {
        return NOT_FOUND;
    }

    public Verification[] getAll() {
        return Verification.values();
    }

    @Override
    public String toString(OutputFormat outputFormat) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (outputFormat) {
            case FULL: 
            case REDUCED: 
            case REDUCED_ENRICHED: {
                msgBuilder.append("{").append("\n").append("  \"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",\n").append("  \"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",\n").append("  \"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("\n").append("}");
                break;
            }
            default: {
                msgBuilder.append("{").append("\"").append("name").append("\"").append(":").append("\"").append(this.name()).append("\"").append(",").append("\"").append("ui_string").append("\"").append(":").append("\"").append(this.uiString).append("\"").append(",").append("\"").append("api_string").append("\"").append(":").append("\"").append(this.apiString).append("\"").append("}");
            }
        }
        return msgBuilder.toString();
    }

    public String toString() {
        return this.toString(OutputFormat.FULL_COMPRESSED);
    }

    public Boolean getAsBoolean() {
        return switch (this) {
            case YES -> Boolean.TRUE;
            case NO -> Boolean.FALSE;
            default -> null;
        };
    }

    public static Verification fromText(String text) {
        if (null == text) {
            return NOT_FOUND;
        }
        return switch (text) {
            case "yes", "YES", "Yes", "y", "Y", "true", "TRUE" -> YES;
            case "no", "NO", "No", "n", "N", "false", "FALSE" -> NO;
            case "unknown", "UNKNOWN", "Unknown" -> UNKNOWN;
            default -> NOT_FOUND;
        };
    }

    public static List<Verification> getAsList() {
        return Arrays.asList(Verification.values());
    }
}

