/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.gson;

import com.github.filosganga.geogson.model.Coordinates;
import com.github.filosganga.geogson.model.positions.AreaPositions;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.MultiDimensionalPositions;
import com.github.filosganga.geogson.model.positions.Positions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class PositionsAdapter
extends TypeAdapter<Positions> {
    public void write(JsonWriter out, Positions value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.beginArray();
            if (value instanceof SinglePosition) {
                SinglePosition sp = (SinglePosition)value;
                out.value(sp.coordinates().getLon()).value(sp.coordinates().getLat());
            } else {
                for (Positions positions : value.children()) {
                    this.write(out, positions);
                }
            }
            out.endArray();
        }
    }

    public Positions read(JsonReader in) throws IOException {
        Positions parsed;
        JsonToken peek = in.peek();
        if (peek == JsonToken.NULL) {
            in.nextNull();
            parsed = null;
        } else if (peek == JsonToken.BEGIN_ARRAY) {
            parsed = this.parsePositions(in);
        } else {
            throw new IllegalArgumentException("The json must be an array or null: " + in.peek());
        }
        return parsed;
    }

    private Positions parsePositions(JsonReader in) throws IOException {
        Optional parsed = Optional.absent();
        if (in.peek() != JsonToken.BEGIN_ARRAY) {
            throw new IllegalArgumentException("The given json is not a valid positions");
        }
        in.beginArray();
        if (in.peek() == JsonToken.NUMBER) {
            parsed = Optional.of((Object)this.parseSinglePosition(in));
        } else if (in.peek() == JsonToken.BEGIN_ARRAY) {
            while (in.hasNext()) {
                Positions thisPositions = this.parsePositions(in);
                if (parsed.equals((Object)Optional.absent()) && thisPositions instanceof LinearPositions) {
                    AreaPositions areaPositions = new AreaPositions((ImmutableList<LinearPositions>)ImmutableList.of((Object)((LinearPositions)thisPositions)));
                    parsed = Optional.of((Object)areaPositions);
                    continue;
                }
                if (parsed.equals((Object)Optional.absent()) && thisPositions instanceof AreaPositions) {
                    MultiDimensionalPositions multiPositions = new MultiDimensionalPositions((ImmutableList<AreaPositions>)ImmutableList.of((Object)((AreaPositions)thisPositions)));
                    parsed = Optional.of((Object)multiPositions);
                    continue;
                }
                parsed = parsed.transform(this.mergeFn(thisPositions)).or(Optional.of((Object)thisPositions));
            }
        }
        in.endArray();
        return (Positions)parsed.orNull();
    }

    private Function<Positions, Positions> mergeFn(final Positions p) {
        return new Function<Positions, Positions>(){

            public Positions apply(Positions input) {
                return input.merge(p);
            }
        };
    }

    private Positions parseSinglePosition(JsonReader in) throws IOException {
        double lon = in.nextDouble();
        double lat = in.nextDouble();
        while (in.peek() != JsonToken.END_ARRAY) {
            in.skipValue();
        }
        SinglePosition parsed = new SinglePosition(Coordinates.of(lon, lat));
        return parsed;
    }
}

