/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.positions.Positions;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public abstract class AbstractGeometry<P extends Positions>
implements Geometry<P>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final P positions;

    protected AbstractGeometry(P positions) {
        Preconditions.checkArgument((positions != null ? 1 : 0) != 0);
        this.positions = positions;
    }

    public static <P extends Positions> Function<AbstractGeometry<P>, P> positionsFn(Class<P> positionsClass) {
        return new Function<AbstractGeometry<P>, P>(){

            public P apply(AbstractGeometry<P> input) {
                return input.positions();
            }
        };
    }

    @Override
    public P positions() {
        return this.positions;
    }

    @Override
    public int size() {
        return this.positions.size();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getClass(), this.positions});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractGeometry other = (AbstractGeometry)obj;
        return Objects.equal(this.positions, other.positions);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("positions", this.positions).toString();
    }
}

