/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.LinearGeometry;
import com.github.filosganga.geogson.model.Point;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;

public class LineString
extends LinearGeometry {
    private static final long serialVersionUID = 1L;

    public LineString(LinearPositions positions) {
        super(LineString.checkPositions(positions));
    }

    private static LinearPositions checkPositions(LinearPositions toCheck) {
        Preconditions.checkArgument((toCheck.size() >= 2 ? 1 : 0) != 0, (Object)"LineString must be composed by a minimum of 2 points.");
        return toCheck;
    }

    public static LineString of(Point ... points) {
        return LineString.of((Iterable<Point>)ImmutableList.copyOf((Collection)Lists.newArrayList((Object[])points)));
    }

    public static LineString of(Iterable<Point> points) {
        return new LineString(new LinearPositions(Iterables.transform(points, LineString.positionsFn(SinglePosition.class))));
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.LINE_STRING;
    }

    public boolean isClosed() {
        return ((LinearPositions)this.positions()).isClosed();
    }
}

