/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.model;

import com.github.filosganga.geogson.model.AbstractGeometry;
import com.github.filosganga.geogson.model.Coordinates;
import com.github.filosganga.geogson.model.Geometry;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.google.common.base.Function;

public class Point
extends AbstractGeometry<SinglePosition> {
    private static final long serialVersionUID = 1L;

    public Point(SinglePosition positions) {
        super(positions);
    }

    public static Point from(double lon, double lat) {
        return Point.from(Coordinates.of(lon, lat));
    }

    public static Point from(Coordinates coordinates) {
        return new Point(new SinglePosition(coordinates));
    }

    public static Function<Point, Coordinates> coordinatesFn() {
        return CoordinatesFn.INSTANCE;
    }

    public Coordinates coordinates() {
        return ((SinglePosition)this.positions()).coordinates();
    }

    public double lon() {
        return this.coordinates().getLon();
    }

    public double lat() {
        return this.coordinates().getLat();
    }

    public Point withLon(double lon) {
        return Point.from(lon, this.coordinates().getLat());
    }

    public Point withLat(double lat) {
        return Point.from(this.coordinates().getLon(), lat);
    }

    @Override
    public Geometry.Type type() {
        return Geometry.Type.POINT;
    }

    private static enum CoordinatesFn implements Function<Point, Coordinates>
    {
        INSTANCE;


        public Coordinates apply(Point input) {
            return input.coordinates();
        }
    }
}

